/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntToLongFunction;
import reactor.util.annotation.Nullable;

class Int2LongHashMap
implements Map<Integer, Long>,
Serializable {
    static final float DEFAULT_LOAD_FACTOR = 0.55f;
    static final int MIN_CAPACITY = 8;
    private static final long serialVersionUID = -690554872053575793L;
    private final float loadFactor;
    private final long missingValue;
    private int resizeThreshold;
    private int size = 0;
    private final boolean shouldAvoidAllocation;
    private long[] entries;
    private KeySet keySet;
    private ValueCollection values;
    private EntrySet entrySet;

    public Int2LongHashMap(long missingValue) {
        this(8, 0.55f, missingValue);
    }

    public Int2LongHashMap(int initialCapacity, float loadFactor, long missingValue) {
        this(initialCapacity, loadFactor, missingValue, true);
    }

    public Int2LongHashMap(int initialCapacity, float loadFactor, long missingValue, boolean shouldAvoidAllocation) {
        Int2LongHashMap.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.missingValue = missingValue;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.capacity(Int2LongHashMap.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public long missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public long get(int key) {
        int mask = this.entries.length - 1;
        int index = Int2LongHashMap.evenHash(key, mask);
        long value = this.missingValue;
        while (this.entries[index + 1] != this.missingValue) {
            if (this.entries[index] == (long)key) {
                value = this.entries[index + 1];
                break;
            }
            index = Int2LongHashMap.next(index, mask);
        }
        return value;
    }

    @Override
    public long put(int key, long value) {
        if (value == this.missingValue) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        int mask = this.entries.length - 1;
        int index = Int2LongHashMap.evenHash(key, mask);
        long oldValue = this.missingValue;
        while (this.entries[index + 1] != this.missingValue) {
            if (this.entries[index] == (long)key) {
                oldValue = this.entries[index + 1];
                break;
            }
            index = Int2LongHashMap.next(index, mask);
        }
        if (oldValue == this.missingValue) {
            ++this.size;
            this.entries[index] = key;
        }
        this.entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        long[] oldEntries = this.entries;
        int length = this.entries.length;
        this.capacity(newCapacity);
        long[] newEntries = this.entries;
        int mask = this.entries.length - 1;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            long value = oldEntries[keyIndex + 1];
            if (value == this.missingValue) continue;
            int key = (int)oldEntries[keyIndex];
            int index = Int2LongHashMap.evenHash(key, mask);
            while (newEntries[index + 1] != this.missingValue) {
                index = Int2LongHashMap.next(index, mask);
            }
            newEntries[index] = key;
            newEntries[index + 1] = value;
        }
    }

    public boolean containsKey(int key) {
        return this.get(key) != this.missingValue;
    }

    public boolean containsValue(long value) {
        boolean found = false;
        if (value != this.missingValue) {
            int length = this.entries.length;
            int remaining = this.size;
            for (int valueIndex = 1; remaining > 0 && valueIndex < length; valueIndex += 2) {
                if (this.missingValue == this.entries[valueIndex]) continue;
                if (value == this.entries[valueIndex]) {
                    found = true;
                    break;
                }
                --remaining;
            }
        }
        return found;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(Int2LongHashMap.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public long computeIfAbsent(int key, IntToLongFunction mappingFunction) {
        long value = this.get(key);
        if (value == this.missingValue && (value = mappingFunction.applyAsLong(key)) != this.missingValue) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    @Nullable
    public Long get(Object key) {
        return this.valOrNull(this.get((Integer)key));
    }

    @Override
    public Long put(Integer key, Long value) {
        return this.valOrNull(this.put((int)key, (long)value));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Long)value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Long> map) {
        for (Map.Entry<? extends Integer, ? extends Long> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.values) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    @Nullable
    public Long remove(Object key) {
        return this.valOrNull(this.remove((Integer)key));
    }

    public long remove(int key) {
        int mask = this.entries.length - 1;
        int keyIndex = Int2LongHashMap.evenHash(key, mask);
        long oldValue = this.missingValue;
        while (this.entries[keyIndex + 1] != this.missingValue) {
            if (this.entries[keyIndex] == (long)key) {
                oldValue = this.entries[keyIndex + 1];
                this.entries[keyIndex + 1] = this.missingValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Int2LongHashMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    private void compactChain(int deleteKeyIndex) {
        int mask = this.entries.length - 1;
        int keyIndex = deleteKeyIndex;
        while (this.entries[(keyIndex = Int2LongHashMap.next(keyIndex, mask)) + 1] != this.missingValue) {
            int hash = Int2LongHashMap.evenHash((int)this.entries[keyIndex], mask);
            if ((keyIndex >= hash || hash > deleteKeyIndex && deleteKeyIndex > keyIndex) && (hash > deleteKeyIndex || deleteKeyIndex > keyIndex)) continue;
            this.entries[deleteKeyIndex] = this.entries[keyIndex];
            this.entries[deleteKeyIndex + 1] = this.entries[keyIndex + 1];
            this.entries[keyIndex + 1] = this.missingValue;
            deleteKeyIndex = keyIndex;
        }
    }

    public long minValue() {
        long missingValue = this.missingValue;
        long min2 = this.size == 0 ? missingValue : Long.MAX_VALUE;
        int length = this.entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            long value = this.entries[valueIndex];
            if (value == missingValue) continue;
            min2 = Math.min(min2, value);
        }
        return min2;
    }

    public long maxValue() {
        long missingValue = this.missingValue;
        long max = this.size == 0 ? missingValue : Long.MIN_VALUE;
        int length = this.entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            long value = this.entries[valueIndex];
            if (value == missingValue) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getIntKey()).append('=').append(entryIterator.getLongValue());
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public long replace(int key, long value) {
        long currentValue = this.get(key);
        if (currentValue != this.missingValue) {
            currentValue = this.put(key, value);
        }
        return currentValue;
    }

    @Override
    public boolean replace(int key, long oldValue, long newValue) {
        long curValue = this.get(key);
        if (curValue != oldValue || curValue == this.missingValue) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return this.size == that.size() && this.entrySet().equals(that.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new long[entriesLength];
        Arrays.fill(this.entries, this.missingValue);
    }

    @Nullable
    private Long valOrNull(long value) {
        return value == this.missingValue ? null : Long.valueOf(value);
    }

    private static int evenHash(int value, int mask) {
        int hash = (value << 1) - (value << 8);
        return hash & mask;
    }

    private static void validateLoadFactor(float loadFactor) {
        if (loadFactor < 0.1f || loadFactor > 0.9f) {
            throw new IllegalArgumentException("load factor must be in the range of 0.1 to 0.9: " + loadFactor);
        }
    }

    private static int findNextPositivePowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Integer, Long>>
    implements Serializable {
        private static final long serialVersionUID = 63641283589916174L;
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Int2LongHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Int2LongHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2LongHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Int2LongHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Long value = Int2LongHashMap.this.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= Int2LongHashMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), Int2LongHashMap.this.size);
            EntryIterator it = this.iterator();
            for (int i = 0; i < array.length; ++i) {
                if (!it.hasNext()) {
                    array[i] = null;
                    break;
                }
                it.next();
                array[i] = it.allocateDuplicateEntry();
            }
            return array;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Long>
    implements Serializable {
        private static final long serialVersionUID = -8925598924781601919L;
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Int2LongHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Int2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Long)o);
        }

        public boolean contains(long value) {
            return Int2LongHashMap.this.containsValue(value);
        }
    }

    public final class KeySet
    extends AbstractSet<Integer>
    implements Serializable {
        private static final long serialVersionUID = -7645453993079742625L;
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Int2LongHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Int2LongHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2LongHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Int2LongHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Integer)o);
        }

        public boolean contains(int key) {
            return Int2LongHashMap.this.containsKey(key);
        }
    }

    public final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Integer, Long>>,
    Map.Entry<Integer, Long>,
    Serializable {
        private static final long serialVersionUID = 1744408438593481051L;

        @Override
        public Integer getKey() {
            return this.getIntKey();
        }

        public int getIntKey() {
            return (int)Int2LongHashMap.this.entries[this.keyPosition()];
        }

        @Override
        public Long getValue() {
            return this.getLongValue();
        }

        public long getLongValue() {
            return Int2LongHashMap.this.entries[this.keyPosition() + 1];
        }

        @Override
        public Long setValue(Long value) {
            return this.setValue((long)value);
        }

        @Override
        public long setValue(long value) {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            if (Int2LongHashMap.this.missingValue == value) {
                throw new IllegalArgumentException();
            }
            int keyPosition = this.keyPosition();
            long prevValue = Int2LongHashMap.this.entries[keyPosition + 1];
            ((Int2LongHashMap)Int2LongHashMap.this).entries[keyPosition + 1] = value;
            return prevValue;
        }

        @Override
        public Map.Entry<Integer, Long> next() {
            this.findNext();
            if (Int2LongHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Integer, Long> allocateDuplicateEntry() {
            return new MapEntry(this.getIntKey(), this.getLongValue());
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.getIntKey()) ^ Long.hashCode(this.getLongValue());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
        }

        public final class MapEntry
        implements Map.Entry<Integer, Long> {
            private final int k;
            private final long v;

            public MapEntry(int k, long v) {
                this.k = k;
                this.v = v;
            }

            @Override
            public Integer getKey() {
                return this.k;
            }

            @Override
            public Long getValue() {
                return this.v;
            }

            @Override
            public Long setValue(Long value) {
                return Int2LongHashMap.this.put(this.k, (long)value);
            }

            @Override
            public int hashCode() {
                return Integer.hashCode(EntryIterator.this.getIntKey()) ^ Long.hashCode(EntryIterator.this.getLongValue());
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return e.getKey() != null && e.getValue() != null && e.getKey().equals(this.k) && e.getValue().equals(this.v);
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class ValueIterator
    extends AbstractIterator
    implements Iterator<Long>,
    Serializable {
        private static final long serialVersionUID = -5670291734793552927L;

        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            this.findNext();
            return Int2LongHashMap.this.entries[this.keyPosition() + 1];
        }
    }

    public final class KeyIterator
    extends AbstractIterator
    implements Iterator<Integer>,
    Serializable {
        private static final long serialVersionUID = 9151493609653852972L;

        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            this.findNext();
            return (int)Int2LongHashMap.this.entries[this.keyPosition()];
        }
    }

    abstract class AbstractIterator
    implements Serializable {
        private static final long serialVersionUID = 5262459454112462433L;
        protected boolean isPositionValid = false;
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        final void reset() {
            int capacity;
            this.isPositionValid = false;
            this.remaining = Int2LongHashMap.this.size;
            long missingValue = Int2LongHashMap.this.missingValue;
            long[] entries = Int2LongHashMap.this.entries;
            int keyIndex = capacity = entries.length;
            if (entries[capacity - 1] != missingValue) {
                for (int i = 1; i < capacity; i += 2) {
                    if (entries[i] != missingValue) continue;
                    keyIndex = i - 1;
                    break;
                }
            }
            this.stopCounter = keyIndex;
            this.positionCounter = keyIndex + capacity;
        }

        protected final int keyPosition() {
            return this.positionCounter & Int2LongHashMap.this.entries.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long[] entries = Int2LongHashMap.this.entries;
            long missingValue = Int2LongHashMap.this.missingValue;
            int mask = entries.length - 1;
            for (int keyIndex = this.positionCounter - 2; keyIndex >= this.stopCounter; keyIndex -= 2) {
                int index = keyIndex & mask;
                if (entries[index + 1] == missingValue) continue;
                this.isPositionValid = true;
                this.positionCounter = keyIndex;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.keyPosition();
            ((Int2LongHashMap)Int2LongHashMap.this).entries[position + 1] = Int2LongHashMap.this.missingValue;
            --Int2LongHashMap.this.size;
            Int2LongHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }
    }
}

