/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame.decoder;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.Payload;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.MetadataPushFrameCodec;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.RequestChannelFrameCodec;
import io.rsocket.frame.RequestFireAndForgetFrameCodec;
import io.rsocket.frame.RequestResponseFrameCodec;
import io.rsocket.frame.RequestStreamFrameCodec;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.util.DefaultPayload;
import java.nio.ByteBuffer;

class DefaultPayloadDecoder
implements PayloadDecoder {
    DefaultPayloadDecoder() {
    }

    @Override
    public Payload apply(ByteBuf byteBuf) {
        ByteBuf m3;
        ByteBuf d;
        FrameType type = FrameHeaderCodec.frameType(byteBuf);
        switch (type) {
            case REQUEST_FNF: {
                d = RequestFireAndForgetFrameCodec.data(byteBuf);
                m3 = RequestFireAndForgetFrameCodec.metadata(byteBuf);
                break;
            }
            case REQUEST_RESPONSE: {
                d = RequestResponseFrameCodec.data(byteBuf);
                m3 = RequestResponseFrameCodec.metadata(byteBuf);
                break;
            }
            case REQUEST_STREAM: {
                d = RequestStreamFrameCodec.data(byteBuf);
                m3 = RequestStreamFrameCodec.metadata(byteBuf);
                break;
            }
            case REQUEST_CHANNEL: {
                d = RequestChannelFrameCodec.data(byteBuf);
                m3 = RequestChannelFrameCodec.metadata(byteBuf);
                break;
            }
            case NEXT: 
            case NEXT_COMPLETE: {
                d = PayloadFrameCodec.data(byteBuf);
                m3 = PayloadFrameCodec.metadata(byteBuf);
                break;
            }
            case METADATA_PUSH: {
                d = Unpooled.EMPTY_BUFFER;
                m3 = MetadataPushFrameCodec.metadata(byteBuf);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported frame type: " + (Object)((Object)type));
            }
        }
        ByteBuffer data = ByteBuffer.allocate(d.readableBytes());
        data.put(d.nioBuffer());
        data.flip();
        if (m3 != null) {
            ByteBuffer metadata = ByteBuffer.allocate(m3.readableBytes());
            metadata.put(m3.nioBuffer());
            metadata.flip();
            return DefaultPayload.create(data, metadata);
        }
        return DefaultPayload.create(data);
    }
}

