/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketClient;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class RSocketClientAdapter
implements RSocketClient {
    private final RSocket rsocket;

    public RSocketClientAdapter(RSocket rsocket) {
        this.rsocket = rsocket;
    }

    public RSocket rsocket() {
        return this.rsocket;
    }

    @Override
    public boolean connect() {
        throw new UnsupportedOperationException("Connect does not apply to a server side RSocket");
    }

    @Override
    public Mono<RSocket> source() {
        return Mono.just(this.rsocket);
    }

    @Override
    public Mono<Void> onClose() {
        return this.rsocket.onClose();
    }

    @Override
    public Mono<Void> fireAndForget(Mono<Payload> payloadMono) {
        return payloadMono.flatMap(this.rsocket::fireAndForget);
    }

    @Override
    public Mono<Payload> requestResponse(Mono<Payload> payloadMono) {
        return payloadMono.flatMap(this.rsocket::requestResponse);
    }

    @Override
    public Flux<Payload> requestStream(Mono<Payload> payloadMono) {
        return payloadMono.flatMapMany(this.rsocket::requestStream);
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.rsocket.requestChannel(payloads);
    }

    @Override
    public Mono<Void> metadataPush(Mono<Payload> payloadMono) {
        return payloadMono.flatMap(this.rsocket::metadataPush);
    }

    @Override
    public void dispose() {
        this.rsocket.dispose();
    }
}

