/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.RequesterResponderSupport;
import io.rsocket.core.SendUtils;
import io.rsocket.core.StateUtils;
import io.rsocket.frame.FrameType;
import io.rsocket.plugins.RequestInterceptor;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;

final class FireAndForgetRequesterMono
extends Mono<Void>
implements Subscription,
Scannable {
    volatile long state;
    static final AtomicLongFieldUpdater<FireAndForgetRequesterMono> STATE = AtomicLongFieldUpdater.newUpdater(FireAndForgetRequesterMono.class, "state");
    final Payload payload;
    final ByteBufAllocator allocator;
    final int mtu;
    final int maxFrameLength;
    final RequesterResponderSupport requesterResponderSupport;
    final DuplexConnection connection;
    @Nullable
    final RequestInterceptor requestInterceptor;

    FireAndForgetRequesterMono(Payload payload, RequesterResponderSupport requesterResponderSupport) {
        this.allocator = requesterResponderSupport.getAllocator();
        this.payload = payload;
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.requesterResponderSupport = requesterResponderSupport;
        this.connection = requesterResponderSupport.getDuplexConnection();
        this.requestInterceptor = requesterResponderSupport.getRequestInterceptor();
    }

    @Override
    public void subscribe(CoreSubscriber<? super Void> actual) {
        int streamId;
        long previousState = StateUtils.markSubscribed(STATE, this);
        if (StateUtils.isSubscribedOrTerminated(previousState)) {
            IllegalStateException e = new IllegalStateException("FireAndForgetMono allows only a single Subscriber");
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(e, FrameType.REQUEST_FNF, null);
            }
            Operators.error(actual, e);
            return;
        }
        actual.onSubscribe(this);
        Payload p = this.payload;
        int mtu = this.mtu;
        try {
            if (!PayloadValidationUtils.isValid(mtu, this.maxFrameLength, p, false)) {
                StateUtils.lazyTerminate(STATE, this);
                IllegalArgumentException e = new IllegalArgumentException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength));
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor != null) {
                    requestInterceptor.onReject(e, FrameType.REQUEST_FNF, p.metadata());
                }
                p.release();
                actual.onError(e);
                return;
            }
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(e, FrameType.REQUEST_FNF, null);
            }
            actual.onError(e);
            return;
        }
        try {
            streamId = this.requesterResponderSupport.getNextStreamId();
        }
        catch (Throwable t) {
            StateUtils.lazyTerminate(STATE, this);
            Throwable ut = Exceptions.unwrap(t);
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(ut, FrameType.REQUEST_FNF, p.metadata());
            }
            p.release();
            actual.onError(ut);
            return;
        }
        RequestInterceptor interceptor = this.requestInterceptor;
        if (interceptor != null) {
            interceptor.onStart(streamId, FrameType.REQUEST_FNF, p.metadata());
        }
        try {
            if (StateUtils.isTerminated(this.state)) {
                p.release();
                if (interceptor != null) {
                    interceptor.onCancel(streamId, FrameType.REQUEST_FNF);
                }
                return;
            }
            SendUtils.sendReleasingPayload(streamId, FrameType.REQUEST_FNF, mtu, p, this.connection, this.allocator, true);
        }
        catch (Throwable e) {
            StateUtils.lazyTerminate(STATE, this);
            if (interceptor != null) {
                interceptor.onTerminate(streamId, FrameType.REQUEST_FNF, e);
            }
            actual.onError(e);
            return;
        }
        StateUtils.lazyTerminate(STATE, this);
        if (interceptor != null) {
            interceptor.onTerminate(streamId, FrameType.REQUEST_FNF, null);
        }
        actual.onComplete();
    }

    @Override
    public void request(long n) {
    }

    @Override
    public void cancel() {
        StateUtils.markTerminated(STATE, this);
    }

    @Override
    @Nullable
    public Void block(Duration m3) {
        return this.block();
    }

    @Override
    @Nullable
    public Void block() {
        int streamId;
        long previousState = StateUtils.markSubscribed(STATE, this);
        if (StateUtils.isSubscribedOrTerminated(previousState)) {
            IllegalStateException e = new IllegalStateException("FireAndForgetMono allows only a single Subscriber");
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(e, FrameType.REQUEST_FNF, null);
            }
            throw e;
        }
        Payload p = this.payload;
        try {
            if (!PayloadValidationUtils.isValid(this.mtu, this.maxFrameLength, p, false)) {
                StateUtils.lazyTerminate(STATE, this);
                IllegalArgumentException e = new IllegalArgumentException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength));
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor != null) {
                    requestInterceptor.onReject(e, FrameType.REQUEST_FNF, p.metadata());
                }
                p.release();
                throw e;
            }
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(e, FrameType.REQUEST_FNF, null);
            }
            throw Exceptions.propagate(e);
        }
        try {
            streamId = this.requesterResponderSupport.getNextStreamId();
        }
        catch (Throwable t) {
            StateUtils.lazyTerminate(STATE, this);
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(Exceptions.unwrap(t), FrameType.REQUEST_FNF, p.metadata());
            }
            p.release();
            throw Exceptions.propagate(t);
        }
        RequestInterceptor interceptor = this.requestInterceptor;
        if (interceptor != null) {
            interceptor.onStart(streamId, FrameType.REQUEST_FNF, p.metadata());
        }
        try {
            SendUtils.sendReleasingPayload(streamId, FrameType.REQUEST_FNF, this.mtu, this.payload, this.connection, this.allocator, true);
        }
        catch (Throwable e) {
            StateUtils.lazyTerminate(STATE, this);
            if (interceptor != null) {
                interceptor.onTerminate(streamId, FrameType.REQUEST_FNF, e);
            }
            throw Exceptions.propagate(e);
        }
        StateUtils.lazyTerminate(STATE, this);
        if (interceptor != null) {
            interceptor.onTerminate(streamId, FrameType.REQUEST_FNF, null);
        }
        return null;
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }

    @Override
    @NonNull
    public String stepName() {
        return "source(FireAndForgetMono)";
    }
}

