/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.rsocket.ConnectionSetupPayload;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface SocketAcceptor {
    public Mono<RSocket> accept(ConnectionSetupPayload var1, RSocket var2);

    public static SocketAcceptor with(RSocket rsocket) {
        return (setup, sendingRSocket) -> Mono.just(rsocket);
    }

    public static SocketAcceptor forFireAndForget(final Function<Payload, Mono<Void>> handler) {
        return SocketAcceptor.with(new RSocket(){

            @Override
            public Mono<Void> fireAndForget(Payload payload) {
                return (Mono)handler.apply(payload);
            }
        });
    }

    public static SocketAcceptor forRequestResponse(final Function<Payload, Mono<Payload>> handler) {
        return SocketAcceptor.with(new RSocket(){

            @Override
            public Mono<Payload> requestResponse(Payload payload) {
                return (Mono)handler.apply(payload);
            }
        });
    }

    public static SocketAcceptor forRequestStream(final Function<Payload, Flux<Payload>> handler) {
        return SocketAcceptor.with(new RSocket(){

            @Override
            public Flux<Payload> requestStream(Payload payload) {
                return (Flux)handler.apply(payload);
            }
        });
    }

    public static SocketAcceptor forRequestChannel(final Function<Publisher<Payload>, Flux<Payload>> handler) {
        return SocketAcceptor.with(new RSocket(){

            @Override
            public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
                return (Flux)handler.apply(payloads);
            }
        });
    }
}

