/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.protect.whitelist;

import com.craftingdead.protect.client.integrity.util.HashUtil;
import com.craftingdead.protect.whitelist.AllowedModEntry;
import com.craftingdead.protect.whitelist.AllowedModsData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;

public final class AllowedModsGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private AllowedModsGenerator() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: AllowedModsGenerator <modsDir> <outputJsonPath>");
            System.exit(1);
        }
        Path modsDir = Paths.get(args[0], new String[0]);
        Path outputPath = Paths.get(args[1], new String[0]);
        try {
            System.out.println("Generating allowed-mods whitelist...");
            System.out.println("Scanning directory: " + modsDir.toAbsolutePath());
            AllowedModsData data = AllowedModsGenerator.generateWhitelist(modsDir);
            System.out.println("Found " + data.getMods().size() + " mods");
            AllowedModsGenerator.writeWhitelist(data, outputPath);
            System.out.println("Whitelist written to: " + outputPath.toAbsolutePath());
            System.out.println("Generation complete!");
        }
        catch (Exception e) {
            System.err.println("Failed to generate whitelist: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static AllowedModsData generateWhitelist(Path modsDir) throws IOException {
        if (!Files.exists(modsDir, new LinkOption[0]) || !Files.isDirectory(modsDir, new LinkOption[0])) {
            throw new IOException("Mods directory does not exist: " + modsDir);
        }
        AllowedModsData data = new AllowedModsData();
        data.setGeneratedAt(Instant.now().toString());
        ArrayList<AllowedModEntry> mods = new ArrayList<AllowedModEntry>();
        try (Stream<Path> files = Files.list(modsDir);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().toLowerCase().endsWith(".jar")).forEach(jarPath -> {
                try {
                    AllowedModEntry entry = AllowedModsGenerator.scanModJar(jarPath);
                    if (entry != null) {
                        mods.add(entry);
                        System.out.println("  \u2713 " + entry.getModId() + " " + entry.getVersion());
                    }
                }
                catch (Exception e) {
                    System.err.println("  \u2717 Failed to scan: " + jarPath.getFileName() + " - " + e.getMessage());
                }
            });
        }
        data.setMods(mods);
        return data;
    }

    private static AllowedModEntry scanModJar(Path jarPath) throws IOException {
        String filename = jarPath.getFileName().toString();
        String sha256 = HashUtil.sha256(jarPath);
        String modId = null;
        String version = null;
        try (JarFile jarFile = new JarFile(jarPath.toFile());){
            Manifest manifest;
            ZipEntry modsToml = jarFile.getEntry("META-INF/mods.toml");
            if (modsToml != null) {
                try (InputStream is = jarFile.getInputStream(modsToml);){
                    String content = new String(is.readAllBytes());
                    modId = AllowedModsGenerator.extractModIdFromToml(content);
                    version = AllowedModsGenerator.extractVersionFromToml(content);
                }
            }
            if (modId == null && (manifest = jarFile.getManifest()) != null) {
                Attributes attrs = manifest.getMainAttributes();
                modId = attrs.getValue("Implementation-Title");
                version = attrs.getValue("Implementation-Version");
            }
            if (modId == null) {
                modId = AllowedModsGenerator.extractModIdFromFilename(filename);
            }
            if (version == null) {
                version = AllowedModsGenerator.extractVersionFromFilename(filename);
            }
        }
        if (modId == null) {
            return null;
        }
        return new AllowedModEntry(modId, version != null ? version : "unknown", filename, sha256);
    }

    private static String extractModIdFromToml(String content) {
        String[] lines;
        for (String line : lines = content.split("\n")) {
            int equalsIdx;
            if (!(line = line.trim()).startsWith("modId") && !line.startsWith("modId=") || (equalsIdx = line.indexOf(61)) == -1) continue;
            String value = line.substring(equalsIdx + 1).trim();
            return value.replace("\"", "").replace("'", "");
        }
        return null;
    }

    private static String extractVersionFromToml(String content) {
        String[] lines;
        for (String line : lines = content.split("\n")) {
            int equalsIdx;
            if (!(line = line.trim()).startsWith("version") || line.startsWith("versionRange") || (equalsIdx = line.indexOf(61)) == -1) continue;
            String value = line.substring(equalsIdx + 1).trim();
            return value.replace("\"", "").replace("'", "").replace("${file.jarVersion}", "");
        }
        return null;
    }

    private static String extractModIdFromFilename(String filename) {
        String name = filename.replace(".jar", "");
        name = name.replaceAll("-\\d+\\.\\d+.*", "");
        name = name.replaceAll("-all$", "");
        name = name.replace("-", "");
        return name.toLowerCase();
    }

    private static String extractVersionFromFilename(String filename) {
        String[] parts;
        for (String part : parts = filename.split("-")) {
            if (!part.matches("\\d+\\.\\d+.*")) continue;
            return part.replace(".jar", "");
        }
        return "unknown";
    }

    public static void writeWhitelist(AllowedModsData data, Path outputPath) throws IOException {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        String json = GSON.toJson((Object)data);
        Files.writeString(outputPath, (CharSequence)json, new OpenOption[0]);
    }
}

