/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.protect.whitelist;

import com.craftingdead.protect.whitelist.AllowedModEntry;
import com.craftingdead.protect.whitelist.AllowedModsData;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AllowedMods {
    private static final Logger logger = LoggerFactory.getLogger(AllowedMods.class);
    private static final Gson GSON = new Gson();
    private static final String BUILTIN_WHITELIST_PATH = "/assets/cdprotect/whitelist/allowed-mods.json";
    private static Path configWhitelistPath;
    private static AllowedMods instance;
    private final Map<String, AllowedModEntry> whitelist = new HashMap<String, AllowedModEntry>();
    private final boolean loaded;

    private AllowedMods(Path configDir) {
        boolean success = false;
        if (configDir != null && Files.exists(configWhitelistPath = configDir.resolve("cdprotect").resolve("allowed-mods.json"), new LinkOption[0])) {
            logger.info("Loading allowed mods whitelist from config: {}", (Object)configWhitelistPath);
            success = this.loadFromFile(configWhitelistPath);
        }
        if (!success) {
            logger.info("Loading allowed mods whitelist from built-in resource");
            success = this.loadFromResource();
        }
        this.loaded = success;
        if (success) {
            logger.info("Allowed mods whitelist loaded: {} entries", (Object)this.whitelist.size());
        } else {
            logger.warn("Failed to load allowed mods whitelist - validation will be limited");
        }
    }

    public static synchronized AllowedMods getInstance(Path configDir) {
        if (instance == null) {
            instance = new AllowedMods(configDir);
        }
        return instance;
    }

    public static synchronized AllowedMods getInstance() {
        if (instance == null) {
            instance = new AllowedMods(null);
        }
        return instance;
    }

    private boolean loadFromFile(Path path) {
        try {
            String json = Files.readString(path);
            AllowedModsData data = (AllowedModsData)GSON.fromJson(json, AllowedModsData.class);
            this.populateWhitelist(data);
            return true;
        }
        catch (IOException e) {
            logger.error("Failed to load whitelist from file: {}", (Object)path, (Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromResource() {
        try (InputStream is = this.getClass().getResourceAsStream(BUILTIN_WHITELIST_PATH);){
            boolean bl;
            if (is == null) {
                logger.warn("Built-in whitelist resource not found: {}", (Object)BUILTIN_WHITELIST_PATH);
                boolean bl2 = false;
                return bl2;
            }
            try (InputStreamReader reader = new InputStreamReader(is);){
                AllowedModsData data = (AllowedModsData)GSON.fromJson((Reader)reader, AllowedModsData.class);
                this.populateWhitelist(data);
                bl = true;
            }
            return bl;
        }
        catch (IOException e) {
            logger.error("Failed to load whitelist from resource", (Throwable)e);
            return false;
        }
    }

    private void populateWhitelist(AllowedModsData data) {
        this.whitelist.clear();
        if (data != null && data.getMods() != null) {
            for (AllowedModEntry entry : data.getMods()) {
                this.whitelist.put(entry.getModId(), entry);
            }
        }
    }

    public Optional<AllowedModEntry> getWhitelistedInfo(String modId) {
        return Optional.ofNullable(this.whitelist.get(modId));
    }

    public boolean isModAllowed(String modId, String version, String hash) {
        AllowedModEntry entry = this.whitelist.get(modId);
        if (entry == null) {
            return false;
        }
        boolean versionMatch = entry.getVersion().equals("unknown") || entry.getVersion().equals(version);
        boolean hashMatch = entry.getSha256().equalsIgnoreCase(hash);
        return versionMatch && hashMatch;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public int getWhitelistSize() {
        return this.whitelist.size();
    }

    public boolean isModIdWhitelisted(String modId) {
        return this.whitelist.containsKey(modId);
    }
}

