/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.protect.client.integrity.scanner;

import com.craftingdead.protect.client.integrity.TransformationAnomalies;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransformationScanner {
    private static final Logger logger = LoggerFactory.getLogger(TransformationScanner.class);
    private static final Set<String> KNOWN_MIXIN_CONFIGS = Set.of("craftingdead.mixins.json", "craftingdeadsurvival.mixins.json", "craftingdeadimmerse.mixins.json");

    private TransformationScanner() {
    }

    public static TransformationAnomalies scanTransformations() {
        List<String> unexpectedCoremods = TransformationScanner.scanCoremods();
        List<String> unexpectedMixins = TransformationScanner.scanMixins();
        return new TransformationAnomalies(unexpectedCoremods, unexpectedMixins);
    }

    private static List<String> scanCoremods() {
        ArrayList<String> unexpected = new ArrayList<String>();
        try {
            logger.debug("Coremod scanning active (basic detection)");
        }
        catch (Exception e) {
            logger.warn("Failed to scan coremods", (Throwable)e);
        }
        return unexpected;
    }

    private static List<String> scanMixins() {
        ArrayList<String> unexpected = new ArrayList<String>();
        try {
            HashSet registeredConfigs = new HashSet();
            logger.debug("Mixin configuration scanning active");
        }
        catch (Exception e) {
            logger.warn("Failed to scan mixin configurations", (Throwable)e);
        }
        return unexpected;
    }
}

