/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.protect.client.integrity.scanner;

import com.craftingdead.protect.client.integrity.LoadedModInfo;
import com.craftingdead.protect.client.integrity.ModValidationResult;
import com.craftingdead.protect.client.integrity.config.ModListConfig;
import com.craftingdead.protect.whitelist.AllowedModEntry;
import com.craftingdead.protect.whitelist.AllowedMods;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModValidator {
    private static final Logger logger = LoggerFactory.getLogger(ModValidator.class);

    private ModValidator() {
    }

    public static ModValidationResult validate(List<LoadedModInfo> loadedMods, ModListConfig config) {
        HashSet<String> loadedModIds = new HashSet<String>();
        for (LoadedModInfo loadedModInfo : loadedMods) {
            loadedModIds.add(loadedModInfo.modId());
        }
        ArrayList<String> missingRequired = new ArrayList<String>();
        for (String requiredMod : config.getRequiredMods()) {
            if (loadedModIds.contains(requiredMod)) continue;
            missingRequired.add(requiredMod);
            logger.warn("Missing required mod: {}", (Object)requiredMod);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> blacklistedSet = config.getBlacklistedModsSet();
        for (String modId : loadedModIds) {
            if (!blacklistedSet.contains(modId)) continue;
            arrayList.add(modId);
            logger.warn("Detected blacklisted mod: {}", (Object)modId);
        }
        ArrayList<String> unknown = new ArrayList<String>();
        AllowedMods whitelist = AllowedMods.getInstance();
        if (config.isStrictMode() || whitelist.isLoaded()) {
            Set<String> allowedSet = config.getAllowedModsSet();
            Set<String> requiredSet = config.getRequiredModsSet();
            for (LoadedModInfo mod : loadedMods) {
                Optional<AllowedModEntry> entry;
                String modId = mod.modId();
                if (ModValidator.isVanillaOrForgeMod(modId)) continue;
                boolean manuallyAllowed = allowedSet.contains(modId) || requiredSet.contains(modId);
                boolean whitelisted = false;
                if (whitelist.isLoaded() && (entry = whitelist.getWhitelistedInfo(modId)).isPresent()) {
                    AllowedModEntry allowedEntry = entry.get();
                    boolean hashMatch = allowedEntry.getSha256().equalsIgnoreCase(mod.sha256());
                    if (hashMatch) {
                        whitelisted = true;
                    } else {
                        logger.warn("Mod '{}' hash mismatch! Expected: {}, Got: {}", new Object[]{modId, allowedEntry.getSha256(), mod.sha256()});
                        unknown.add(modId + " (modified)");
                    }
                }
                if (manuallyAllowed || whitelisted) continue;
                if (config.isStrictMode()) {
                    unknown.add(modId);
                    logger.info("Unknown mod detected: {}", (Object)modId);
                    continue;
                }
                if (!whitelist.isLoaded()) continue;
                unknown.add(modId + " (not in whitelist)");
                logger.warn("Mod not in whitelist: {}", (Object)modId);
            }
        }
        return new ModValidationResult(missingRequired, arrayList, unknown);
    }

    private static boolean isVanillaOrForgeMod(String modId) {
        return modId.equals("minecraft") || modId.equals("forge") || modId.startsWith("forge");
    }
}

