/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.protect.client.integrity.scanner;

import com.craftingdead.protect.client.integrity.ClassIntegrityResult;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassIntegrityScanner {
    private static final Logger logger = LoggerFactory.getLogger(ClassIntegrityScanner.class);
    private static final String[] CRITICAL_CLASSES = new String[]{"com.craftingdead.core.CraftingDead", "com.craftingdead.immerse.CraftingDeadImmerse", "com.craftingdead.survival.CraftingDeadSurvival"};

    private ClassIntegrityScanner() {
    }

    public static List<ClassIntegrityResult> scanClassIntegrity() {
        ArrayList<ClassIntegrityResult> results = new ArrayList<ClassIntegrityResult>();
        for (String className : CRITICAL_CLASSES) {
            try {
                ClassIntegrityResult result = ClassIntegrityScanner.checkClassIntegrity(className);
                results.add(result);
                if (result.valid()) continue;
                logger.warn("Class integrity violation: {} loaded from {} instead of {}", new Object[]{className, result.actualSource(), result.expectedSource()});
            }
            catch (ClassNotFoundException e) {
                logger.warn("Critical class not found: {}", (Object)className);
                results.add(new ClassIntegrityResult(className, "unknown", "not_found", false));
            }
            catch (Exception e) {
                logger.error("Failed to check integrity for class: {}", (Object)className, (Object)e);
            }
        }
        return results;
    }

    private static ClassIntegrityResult checkClassIntegrity(String className) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        ProtectionDomain pd = clazz.getProtectionDomain();
        if (pd == null) {
            return new ClassIntegrityResult(className, "unknown", "no_protection_domain", false);
        }
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return new ClassIntegrityResult(className, "unknown", "no_code_source", false);
        }
        URL location = cs.getLocation();
        String actualSource = location != null ? location.toString() : "unknown";
        String expectedSource = ClassIntegrityScanner.determineExpectedSource(className);
        boolean valid = actualSource.contains(expectedSource);
        return new ClassIntegrityResult(className, expectedSource, actualSource, valid);
    }

    private static String determineExpectedSource(String className) {
        if (className.startsWith("com.craftingdead.core")) {
            return "crafting-dead-core";
        }
        if (className.startsWith("com.craftingdead.immerse")) {
            return "crafting-dead-immerse";
        }
        if (className.startsWith("com.craftingdead.survival")) {
            return "crafting-dead-survival";
        }
        if (className.startsWith("com.craftingdead.decoration")) {
            return "crafting-dead-decoration";
        }
        return "crafting-dead";
    }
}

