/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.protect.client.integrity.config;

import com.craftingdead.protect.client.integrity.config.ModListConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigLoader.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private ConfigLoader() {
    }

    public static ModListConfig loadModListConfig(Path configPath) {
        if (!Files.exists(configPath, new LinkOption[0])) {
            logger.info("Config file not found: {}, creating default", (Object)configPath);
            ModListConfig defaultConfig = ConfigLoader.createDefaultConfig();
            ConfigLoader.saveModListConfig(configPath, defaultConfig);
            return defaultConfig;
        }
        try {
            String json = Files.readString(configPath);
            return (ModListConfig)GSON.fromJson(json, ModListConfig.class);
        }
        catch (IOException e) {
            logger.error("Failed to load config from: {}", (Object)configPath, (Object)e);
            return ConfigLoader.createDefaultConfig();
        }
    }

    public static void saveModListConfig(Path configPath, ModListConfig config) {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)config);
            Files.writeString(configPath, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("Failed to save config to: {}", (Object)configPath, (Object)e);
        }
    }

    private static ModListConfig createDefaultConfig() {
        ModListConfig config = new ModListConfig();
        config.setRequiredMods(List.of("minecraft", "forge", "craftingdead", "craftingdeadimmerse", "craftingdeadsurvival"));
        config.setBlacklistedMods(List.of("wurst", "baritone", "meteor-client", "lambda", "aristois"));
        config.setStrictMode(false);
        return config;
    }
}

