/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.protect.client.integrity;

import com.craftingdead.protect.client.integrity.ClassIntegrityResult;
import com.craftingdead.protect.client.integrity.LoadedModInfo;
import com.craftingdead.protect.client.integrity.ModValidationResult;
import com.craftingdead.protect.client.integrity.TransformationAnomalies;
import java.util.List;

public record ClientEnvironmentReport(List<LoadedModInfo> mods, ModValidationResult modValidation, TransformationAnomalies transformIssues, List<ClassIntegrityResult> classIntegrity, long timestamp) {
    public ClientEnvironmentReport {
        mods = List.copyOf(mods);
        classIntegrity = List.copyOf(classIntegrity);
    }

    public boolean hasAnyIssues() {
        return this.modValidation.hasIssues() || this.transformIssues.hasAnomalies() || this.classIntegrity.stream().anyMatch(c -> !c.valid());
    }

    public int getTotalIssueCount() {
        int count = 0;
        count += this.modValidation.missingRequiredMods().size();
        count += this.modValidation.blacklistedModsDetected().size();
        count += this.modValidation.unknownMods().size();
        count += this.transformIssues.unexpectedCoremods().size();
        count += this.transformIssues.unexpectedMixins().size();
        return count += (int)this.classIntegrity.stream().filter(c -> !c.valid()).count();
    }
}

