/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.protect;

public enum ProtectionMode {
    DEV,
    RELEASE;

    private static final String PROPERTY_NAME = "cd.protectionMode";
    private static final ProtectionMode CURRENT_MODE;

    public static ProtectionMode current() {
        return CURRENT_MODE;
    }

    public static boolean isDev() {
        return CURRENT_MODE == DEV;
    }

    public static boolean isRelease() {
        return CURRENT_MODE == RELEASE;
    }

    private static ProtectionMode determineMode() {
        try {
            String mode;
            switch (mode = System.getProperty(PROPERTY_NAME, "dev").toLowerCase()) {
                case "release": 
                case "prod": 
                case "production": {
                    return RELEASE;
                }
            }
            return DEV;
        }
        catch (Exception e) {
            return DEV;
        }
    }

    public String getDescription() {
        switch (this) {
            case DEV: {
                return "Development Mode (debugging enabled)";
            }
            case RELEASE: {
                return "Release Mode (full protection)";
            }
        }
        return "Unknown Mode";
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    static {
        CURRENT_MODE = ProtectionMode.determineMode();
    }
}

