/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.protect;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NativeProtection {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeProtection.class);
    private static final boolean LOADED;
    private static final String LIBRARY_NAME = "cdprotect";

    private NativeProtection() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean isLoaded() {
        return LOADED;
    }

    public static native boolean nativeIntegrityOk();

    public static native boolean nativeEnvClean();

    public static native int nativeChallenge(int var0);

    public static boolean checkIntegrity() {
        if (!LOADED) {
            return false;
        }
        try {
            return NativeProtection.nativeIntegrityOk();
        }
        catch (Throwable t) {
            LOGGER.error("Native integrity check failed with exception", t);
            return false;
        }
    }

    public static boolean checkEnvironment() {
        if (!LOADED) {
            return false;
        }
        try {
            return NativeProtection.nativeEnvClean();
        }
        catch (Throwable t) {
            LOGGER.error("Native environment check failed with exception", t);
            return false;
        }
    }

    public static int performChallenge(int seed) {
        if (!LOADED) {
            return 0;
        }
        try {
            return NativeProtection.nativeChallenge(seed);
        }
        catch (Throwable t) {
            LOGGER.error("Native challenge failed with exception", t);
            return 0;
        }
    }

    public static int computeExpectedChallenge(int seed) {
        int result = seed;
        result = result * -1640531527 ^ result >>> 16;
        result = result * -2048144789 ^ result >>> 13;
        result = result * -1028477387 ^ result >>> 16;
        return result;
    }

    public static boolean verifyNativeLibrary(int seed) {
        int expectedResult;
        if (!LOADED) {
            return false;
        }
        int nativeResult = NativeProtection.performChallenge(seed);
        if (nativeResult != (expectedResult = NativeProtection.computeExpectedChallenge(seed))) {
            LOGGER.warn("Native library challenge verification FAILED! Expected: {}, Got: {}. Native library may be compromised.", (Object)expectedResult, (Object)nativeResult);
            return false;
        }
        return true;
    }

    public static String getStatus() {
        if (!LOADED) {
            return "Native protection: UNAVAILABLE (using Java-only fallback)";
        }
        StringBuilder status = new StringBuilder("Native protection: ACTIVE");
        try {
            boolean integrity = NativeProtection.nativeIntegrityOk();
            boolean environment = NativeProtection.nativeEnvClean();
            status.append(" [Integrity: ").append(integrity ? "OK" : "FAIL");
            status.append(", Environment: ").append(environment ? "CLEAN" : "SUSPICIOUS");
            status.append("]");
        }
        catch (Throwable t) {
            status.append(" [Error: ").append(t.getMessage()).append("]");
        }
        return status.toString();
    }

    static {
        boolean loaded = false;
        try {
            try {
                int testResult = NativeProtection.nativeChallenge(42);
                boolean envTest = NativeProtection.nativeEnvClean();
                loaded = true;
                LOGGER.info("Native Protection: LOADED (challenge test: {}, env test: {})", (Object)testResult, (Object)envTest);
            }
            catch (UnsatisfiedLinkError linkError) {
                LOGGER.debug("Native library not loaded yet (will be loaded by anticheat module)");
            }
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warn("Native protection library '{}' could not be loaded: {}", (Object)LIBRARY_NAME, (Object)e.getMessage());
            LOGGER.debug("Native library load error details", (Throwable)e);
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected error checking native protection library", t);
        }
        LOADED = loaded;
    }
}

