/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.protect;

import com.craftingdead.protect.ProtectionMode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProtectionDomain;
import java.util.HexFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntegrityChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrityChecker.class);
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final int BUFFER_SIZE = 8192;

    private IntegrityChecker() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String computeJarHash(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            ProtectionDomain domain = clazz.getProtectionDomain();
            if (domain == null || domain.getCodeSource() == null) {
                return null;
            }
            URL location = domain.getCodeSource().getLocation();
            if (location == null) {
                return null;
            }
            return IntegrityChecker.computeUrlHash(location);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String computeResourceHash(String resourcePath, ClassLoader classLoader) {
        if (resourcePath == null || classLoader == null) {
            return null;
        }
        try {
            URL resourceUrl = classLoader.getResource(resourcePath);
            if (resourceUrl == null) {
                return null;
            }
            return IntegrityChecker.computeUrlHash(resourceUrl);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String computeUrlHash(URL url) {
        String string;
        block10: {
            if (url == null) {
                return null;
            }
            InputStream input = url.openStream();
            try {
                int bytesRead;
                MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITHM);
                byte[] buffer = new byte[8192];
                while ((bytesRead = input.read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
                byte[] hashBytes = digest.digest();
                string = HexFormat.of().formatHex(hashBytes);
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    return null;
                }
            }
            input.close();
        }
        return string;
    }

    public static boolean compareHashes(String hash1, String hash2) {
        if (hash1 == null || hash2 == null) {
            return false;
        }
        return hash1.equalsIgnoreCase(hash2);
    }

    public static boolean verifyJarIntegrity(Class<?> clazz, String expectedHash) {
        String actualHash = IntegrityChecker.computeJarHash(clazz);
        return IntegrityChecker.compareHashes(actualHash, expectedHash);
    }

    public static boolean verifyResourceIntegrity(String resourcePath, ClassLoader classLoader, String expectedHash) {
        String actualHash = IntegrityChecker.computeResourceHash(resourcePath, classLoader);
        return IntegrityChecker.compareHashes(actualHash, expectedHash);
    }

    public static boolean performComprehensiveIntegrityCheck(Class<?> clazz, String expectedHash) {
        ProtectionMode mode = ProtectionMode.current();
        boolean javaIntegrityOk = true;
        boolean nativeIntegrityOk = true;
        if (expectedHash != null && !(javaIntegrityOk = IntegrityChecker.verifyJarIntegrity(clazz, expectedHash))) {
            LOGGER.warn("Java integrity check FAILED for {}", (Object)clazz.getName());
        }
        if (ProtectionMode.isRelease()) {
            return javaIntegrityOk;
        }
        if (!javaIntegrityOk) {
            LOGGER.debug("Integrity check failures in DEV mode (not enforced)");
        }
        return true;
    }

    public static boolean quickIntegrityCheck() {
        return true;
    }
}

