/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.protect;

import com.craftingdead.protect.ProtectionMode;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnvironmentChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentChecker.class);
    private static final String JDWP_OPTION = "jdwp";
    private static final String AGENT_OPTION = "-javaagent";
    private static final String[] SUSPICIOUS_AGENTS = new String[]{"intellij", "eclipse", "netbeans", "jrebel", "yourkit", "jprofiler", "visualvm", "jdwp", "debug"};

    private EnvironmentChecker() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean isDebuggingActive() {
        try {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            List<String> arguments = runtimeMxBean.getInputArguments();
            for (String arg : arguments) {
                if (!arg.toLowerCase().contains(JDWP_OPTION)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasJavaAgents() {
        try {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            List<String> arguments = runtimeMxBean.getInputArguments();
            for (String arg : arguments) {
                if (!arg.startsWith(AGENT_OPTION)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasSuspiciousAgents() {
        try {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            List<String> arguments = runtimeMxBean.getInputArguments();
            for (String arg : arguments) {
                String lowerArg = arg.toLowerCase();
                for (String suspicious : SUSPICIOUS_AGENTS) {
                    if (!lowerArg.contains(suspicious)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isHostileEnvironment() {
        boolean javaHostile;
        ProtectionMode mode = ProtectionMode.current();
        boolean bl = javaHostile = EnvironmentChecker.isDebuggingActive() || EnvironmentChecker.hasJavaAgents() || EnvironmentChecker.hasSuspiciousAgents();
        if (javaHostile) {
            LOGGER.warn("Java-based hostile environment detection triggered");
        }
        return javaHostile;
    }

    public static boolean performComprehensiveEnvironmentCheck() {
        boolean javaClean;
        ProtectionMode mode = ProtectionMode.current();
        boolean bl = javaClean = !EnvironmentChecker.isHostileEnvironment();
        if (ProtectionMode.isRelease()) {
            return javaClean;
        }
        if (!javaClean) {
            LOGGER.debug("Environment check failures in DEV mode (not enforced)");
        }
        return true;
    }

    public static boolean quickEnvironmentCheck() {
        return !EnvironmentChecker.isHostileEnvironment();
    }

    public static String getJvmArguments() {
        try {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            return String.join((CharSequence)" ", runtimeMxBean.getInputArguments());
        }
        catch (Exception e) {
            return "";
        }
    }
}

