/*
 * Crafting Dead
 * Copyright (C) 2022  NexusNode LTD
 *
 * This Non-Commercial Software License Agreement (the "Agreement") is made between
 * you (the "Licensee") and NEXUSNODE (BRAD HUNTER). (the "Licensor").
 * By installing or otherwise using Crafting Dead (the "Software"), you agree to be
 * bound by the terms and conditions of this Agreement as may be revised from time
 * to time at Licensor's sole discretion.
 *
 * If you do not agree to the terms and conditions of this Agreement do not download,
 * copy, reproduce or otherwise use any of the source code available online at any time.
 *
 * https://github.com/nexusnode/crafting-dead/blob/1.18.x/LICENSE.txt
 *
 * https://craftingdead.net/terms.php
 */

package com.craftingdead.protect.whitelist;

/**
 * Represents a single whitelisted mod entry with all validation data.
 */
public class AllowedModEntry {
  
  private String modId;
  private String version;
  private String filename;
  private String sha256;
  
  public AllowedModEntry() {}
  
  public AllowedModEntry(String modId, String version, String filename, String sha256) {
    this.modId = modId;
    this.version = version;
    this.filename = filename;
    this.sha256 = sha256;
  }
  
  public String getModId() {
    return modId;
  }
  
  public void setModId(String modId) {
    this.modId = modId;
  }
  
  public String getVersion() {
    return version;
  }
  
  public void setVersion(String version) {
    this.version = version;
  }
  
  public String getFilename() {
    return filename;
  }
  
  public void setFilename(String filename) {
    this.filename = filename;
  }
  
  public String getSha256() {
    return sha256;
  }
  
  public void setSha256(String sha256) {
    this.sha256 = sha256;
  }
  
  @Override
  public String toString() {
    return "AllowedModEntry{modId='" + modId + "', version='" + version + 
           "', filename='" + filename + "', sha256='" + sha256 + "'}";
  }
}
