/*
 * Crafting Dead
 * Copyright (C) 2022  NexusNode LTD
 *
 * This Non-Commercial Software License Agreement (the "Agreement") is made between
 * you (the "Licensee") and NEXUSNODE (BRAD HUNTER). (the "Licensor").
 * By installing or otherwise using Crafting Dead (the "Software"), you agree to be
 * bound by the terms and conditions of this Agreement as may be revised from time
 * to time at Licensor's sole discretion.
 *
 * If you do not agree to the terms and conditions of this Agreement do not download,
 * copy, reproduce or otherwise use any of the source code available online at any time.
 *
 * https://github.com/nexusnode/crafting-dead/blob/1.18.x/LICENSE.txt
 *
 * https://craftingdead.net/terms.php
 */

package com.craftingdead.protect.client.integrity.config;

import java.util.List;
import java.util.Set;

/**
 * Configuration structure for mod whitelist and blacklist.
 */
public class ModListConfig {
  
  private List<String> requiredMods = List.of();
  private List<String> blacklistedMods = List.of();
  private List<String> allowedMods = List.of();
  private boolean strictMode = false;
  
  public List<String> getRequiredMods() {
    return requiredMods;
  }
  
  public void setRequiredMods(List<String> requiredMods) {
    this.requiredMods = requiredMods;
  }
  
  public List<String> getBlacklistedMods() {
    return blacklistedMods;
  }
  
  public void setBlacklistedMods(List<String> blacklistedMods) {
    this.blacklistedMods = blacklistedMods;
  }
  
  public List<String> getAllowedMods() {
    return allowedMods;
  }
  
  public void setAllowedMods(List<String> allowedMods) {
    this.allowedMods = allowedMods;
  }
  
  public boolean isStrictMode() {
    return strictMode;
  }
  
  public void setStrictMode(boolean strictMode) {
    this.strictMode = strictMode;
  }
  
  public Set<String> getRequiredModsSet() {
    return Set.copyOf(requiredMods);
  }
  
  public Set<String> getBlacklistedModsSet() {
    return Set.copyOf(blacklistedMods);
  }
  
  public Set<String> getAllowedModsSet() {
    return Set.copyOf(allowedMods);
  }
}
