/*
 * Crafting Dead
 * Copyright (C) 2022  NexusNode LTD
 *
 * This Non-Commercial Software License Agreement (the "Agreement") is made between
 * you (the "Licensee") and NEXUSNODE (BRAD HUNTER). (the "Licensor").
 * By installing or otherwise using Crafting Dead (the "Software"), you agree to be
 * bound by the terms and conditions of this Agreement as may be revised from time
 * to time at Licensor's sole discretion.
 *
 * If you do not agree to the terms and conditions of this Agreement do not download,
 * copy, reproduce or otherwise use any of the source code available online at any time.
 *
 * https://github.com/nexusnode/crafting-dead/blob/1.18.x/LICENSE.txt
 *
 * https://craftingdead.net/terms.php
 */

package com.craftingdead.protect.client.integrity;

import java.nio.file.Path;

/**
 * Represents information about a loaded mod.
 * Used for integrity checking and mod validation.
 */
public record LoadedModInfo(
    String modId,
    String version,
    Path jarLocation,
    String sha256,
    boolean isCoremod,
    boolean hasMixins
) {
  
  public LoadedModInfo {
    if (modId == null || modId.isEmpty()) {
      throw new IllegalArgumentException("modId cannot be null or empty");
    }
    if (version == null || version.isEmpty()) {
      throw new IllegalArgumentException("version cannot be null or empty");
    }
  }
}
