/*
 * Crafting Dead
 * Copyright (C) 2022  NexusNode LTD
 *
 * This Non-Commercial Software License Agreement (the "Agreement") is made between
 * you (the "Licensee") and NEXUSNODE (BRAD HUNTER). (the "Licensor").
 * By installing or otherwise using Crafting Dead (the "Software"), you agree to be
 * bound by the terms and conditions of this Agreement as may be revised from time
 * to time at Licensor's sole discretion.
 *
 * If you do not agree to the terms and conditions of this Agreement do not download,
 * copy, reproduce or otherwise use any of the source code available online at any time.
 *
 * https://github.com/nexusnode/crafting-dead/blob/1.18.x/LICENSE.txt
 *
 * https://craftingdead.net/terms.php
 */

package com.craftingdead.protect.client.integrity;

import java.util.List;

/**
 * Complete environment integrity report for the client.
 * Contains all collected information about mods, transformations, and class integrity.
 */
public record ClientEnvironmentReport(
    List<LoadedModInfo> mods,
    ModValidationResult modValidation,
    TransformationAnomalies transformIssues,
    List<ClassIntegrityResult> classIntegrity,
    long timestamp
) {
  
  public ClientEnvironmentReport {
    mods = List.copyOf(mods);
    classIntegrity = List.copyOf(classIntegrity);
  }
  
  public boolean hasAnyIssues() {
    return modValidation.hasIssues() 
        || transformIssues.hasAnomalies()
        || classIntegrity.stream().anyMatch(c -> !c.valid());
  }
  
  public int getTotalIssueCount() {
    int count = 0;
    count += modValidation.missingRequiredMods().size();
    count += modValidation.blacklistedModsDetected().size();
    count += modValidation.unknownMods().size();
    count += transformIssues.unexpectedCoremods().size();
    count += transformIssues.unexpectedMixins().size();
    count += (int) classIntegrity.stream().filter(c -> !c.valid()).count();
    return count;
  }
}
