/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.rsocket;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.publisher.Mono;
import reactor.netty.FutureMono;
import reactor.netty.resources.LoopResources;

public class DelegatedLoopResources
implements LoopResources {
    private static final int BOSS_THREADS_NUM = 1;
    private static final DefaultThreadFactory BOSS_THREAD_FACTORY = new DefaultThreadFactory("boss-transport", true);
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final AtomicBoolean running = new AtomicBoolean(true);

    private DelegatedLoopResources(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
    }

    public static DelegatedLoopResources newClientLoopResources(EventLoopGroup workerGroup) {
        return new DelegatedLoopResources(null, workerGroup);
    }

    public static DelegatedLoopResources newServerLoopResources(EventLoopGroup workerGroup) {
        EpollEventLoopGroup bossGroup = Epoll.isAvailable() ? new EpollEventLoopGroup(1, (ThreadFactory)BOSS_THREAD_FACTORY) : new NioEventLoopGroup(1, (ThreadFactory)BOSS_THREAD_FACTORY);
        return new DelegatedLoopResources((EventLoopGroup)bossGroup, workerGroup);
    }

    public EventLoopGroup onClient(boolean useNative) {
        return this.workerGroup;
    }

    public EventLoopGroup onServer(boolean useNative) {
        return this.workerGroup;
    }

    public EventLoopGroup onServerSelect(boolean useNative) {
        return this.bossGroup;
    }

    public boolean daemon() {
        return true;
    }

    public boolean isDisposed() {
        return !this.running.get();
    }

    public Mono<Void> disposeLater() {
        return Mono.defer(() -> {
            Mono promise = Mono.empty();
            if (this.running.compareAndSet(true, false) && this.bossGroup != null) {
                promise = FutureMono.from((Future)this.bossGroup.shutdownGracefully());
            }
            return promise;
        });
    }

    public String toString() {
        return "DelegatedLoopResources{bossGroup=" + this.bossGroup + ", workerGroup=" + this.workerGroup + ", running=" + this.running + "}";
    }
}

