/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.examples.services;

import io.scalecube.services.examples.services.Service2;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Schedulers;

class Service2Impl
implements Service2 {
    private static final long SLEEP_PERIOD_NS = 10000L;

    Service2Impl() {
    }

    @Override
    public Mono<String> oneDelay(long interval) {
        return Mono.create(sink -> this.doWork((MonoSink<String>)sink, interval)).subscribeOn(Schedulers.parallel()).log("oneDelay    |");
    }

    private void doWork(MonoSink<String> sink, long interval) {
        AtomicBoolean isActive = new AtomicBoolean(true);
        sink.onCancel(() -> isActive.set(false));
        sink.onDispose(() -> isActive.set(false));
        long started = System.currentTimeMillis();
        sink.onRequest(r -> {
            while (isActive.get()) {
                long now = System.currentTimeMillis();
                if (now - started > interval) {
                    sink.success((Object)this.toResponse(now));
                    return;
                }
                LockSupport.parkNanos(10000L);
            }
        });
    }

    private String toResponse(long now) {
        String currentThread = Thread.currentThread().getName();
        LocalDateTime time = LocalDateTime.ofInstant(Instant.ofEpochMilli(now), ZoneId.systemDefault());
        return "|" + currentThread + "| response: " + time;
    }
}

