/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.examples.helloworld;

import io.scalecube.cluster.transport.api.TransportFactory;
import io.scalecube.net.Address;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.discovery.ScalecubeServiceDiscovery;
import io.scalecube.services.examples.helloworld.service.GreetingServiceImpl;
import io.scalecube.services.examples.helloworld.service.api.Greeting;
import io.scalecube.services.impl.Microservices;
import io.scalecube.services.transport.rsocket.RSocketServiceTransport;
import io.scalecube.transport.netty.websocket.WebsocketTransportFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class Example2 {
    static final String SERVICE_QUALIFIER = "/io.scalecube.Greetings/sayHello";

    public static void main(String[] args) {
        Microservices seed = Microservices.builder().discovery("seed", serviceEndpoint -> new ScalecubeServiceDiscovery().transport(cfg -> cfg.transportFactory((TransportFactory)new WebsocketTransportFactory())).options(opts -> opts.metadata((Object)serviceEndpoint))).transport(RSocketServiceTransport::new).startAwait();
        Address seedAddress = seed.discovery().address();
        Microservices ms = Microservices.builder().discovery(endpoint -> new ScalecubeServiceDiscovery().transport(cfg -> cfg.transportFactory((TransportFactory)new WebsocketTransportFactory())).options(opts -> opts.metadata((Object)endpoint)).membership(cfg -> cfg.seedMembers(new Address[]{seedAddress}))).transport(RSocketServiceTransport::new).services(new Object[]{new GreetingServiceImpl()}).startAwait();
        ServiceCall service = seed.call();
        ServiceMessage request = ServiceMessage.builder().qualifier(SERVICE_QUALIFIER).data((Object)"joe").build();
        Mono publisher = service.requestOne(request, Greeting.class);
        Mono.from((Publisher)publisher).subscribe(consumer -> {
            Greeting greeting = (Greeting)consumer.data(Greeting.class);
            System.out.println(greeting.message());
        });
        Mono.whenDelayError((Publisher[])new Publisher[]{seed.shutdown(), ms.shutdown()}).block();
    }
}

