/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.examples.codecs;

import io.scalecube.cluster.transport.api.TransportFactory;
import io.scalecube.net.Address;
import io.scalecube.services.discovery.ScalecubeServiceDiscovery;
import io.scalecube.services.examples.helloworld.service.GreetingServiceImpl;
import io.scalecube.services.examples.helloworld.service.api.GreetingsService;
import io.scalecube.services.impl.Microservices;
import io.scalecube.services.transport.rsocket.RSocketServiceTransport;
import io.scalecube.transport.netty.websocket.WebsocketTransportFactory;

public class Example1 {
    public static final String JSON = "application/json";
    public static final String PROTOSTUFF = "application/protostuff";
    public static final String OCTET_STREAM = "application/octet-stream";

    public static void main(String[] args) {
        Microservices seed = Microservices.builder().discovery(serviceEndpoint -> new ScalecubeServiceDiscovery().transport(cfg -> cfg.transportFactory((TransportFactory)new WebsocketTransportFactory())).options(opts -> opts.metadata((Object)serviceEndpoint))).transport(RSocketServiceTransport::new).defaultContentType(PROTOSTUFF).startAwait();
        Address seedAddress = seed.discovery().address();
        Microservices ms = Microservices.builder().discovery(endpoint -> new ScalecubeServiceDiscovery().transport(cfg -> cfg.transportFactory((TransportFactory)new WebsocketTransportFactory())).options(opts -> opts.metadata((Object)endpoint)).membership(cfg -> cfg.seedMembers(new Address[]{seedAddress}))).transport(RSocketServiceTransport::new).services(new Object[]{new GreetingServiceImpl()}).startAwait();
        ((GreetingsService)seed.call().api(GreetingsService.class)).sayHello("joe (on default dataFormat PROTOSTUFF)").subscribe(consumer -> System.out.println(consumer.message()));
        ((GreetingsService)seed.call().contentType(JSON).api(GreetingsService.class)).sayHello("alice (on JSON dataFormat)").subscribe(consumer -> System.out.println(consumer.message()));
        ((GreetingsService)seed.call().contentType(OCTET_STREAM).api(GreetingsService.class)).sayHello("bob (on java native Serializable/Externalizable dataFormat)").subscribe(consumer -> System.out.println(consumer.message()));
        seed.onShutdown().block();
        ms.onShutdown().block();
    }
}

