/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.examples.auth;

import io.scalecube.cluster.transport.api.TransportFactory;
import io.scalecube.net.Address;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.auth.Authenticator;
import io.scalecube.services.auth.CredentialsSupplier;
import io.scalecube.services.discovery.ScalecubeServiceDiscovery;
import io.scalecube.services.examples.auth.SecuredServiceByUserProfile;
import io.scalecube.services.examples.auth.SecuredServiceByUserProfileImpl;
import io.scalecube.services.examples.auth.UserProfile;
import io.scalecube.services.exceptions.UnauthorizedException;
import io.scalecube.services.impl.Microservices;
import io.scalecube.services.transport.rsocket.RSocketServiceTransport;
import io.scalecube.transport.netty.websocket.WebsocketTransportFactory;
import java.time.Duration;
import java.util.HashMap;
import java.util.UUID;
import reactor.core.publisher.Mono;

public class ServiceTransportAuthExample {
    public static void main(String[] args) {
        Microservices service = Microservices.builder().discovery(serviceEndpoint -> new ScalecubeServiceDiscovery().transport(cfg -> cfg.transportFactory((TransportFactory)new WebsocketTransportFactory())).options(opts -> opts.metadata((Object)serviceEndpoint))).transport(() -> new RSocketServiceTransport().authenticator(ServiceTransportAuthExample.authenticator())).services(new Object[]{new SecuredServiceByUserProfileImpl()}).startAwait();
        Microservices caller = Microservices.builder().discovery(endpoint -> ServiceTransportAuthExample.discovery(service, endpoint)).transport(() -> new RSocketServiceTransport().credentialsSupplier(ServiceTransportAuthExample.credentialsSupplier())).startAwait();
        String response = (String)((SecuredServiceByUserProfile)caller.call().api(SecuredServiceByUserProfile.class)).hello(UUID.randomUUID().toString()).block(Duration.ofSeconds(3L));
        System.err.println("### Received 'caller' response: " + response);
    }

    private static Authenticator<UserProfile> authenticator() {
        return headers -> {
            String username = (String)headers.get("username");
            String password = (String)headers.get("password");
            if ("Alice".equals(username) && "qwerty".equals(password)) {
                HashMap<String, String> authData = new HashMap<String, String>();
                authData.put("name", "Alice");
                authData.put("role", "ADMIN");
                return Mono.just((Object)new UserProfile((String)authData.get("name"), (String)authData.get("role")));
            }
            return Mono.error((Throwable)new UnauthorizedException("Authentication failed (username or password incorrect)"));
        };
    }

    private static CredentialsSupplier credentialsSupplier() {
        return service -> {
            HashMap<String, String> creds = new HashMap<String, String>();
            creds.put("username", "Alice");
            creds.put("password", "qwerty");
            return Mono.just(creds);
        };
    }

    private static ScalecubeServiceDiscovery discovery(Microservices service, ServiceEndpoint endpoint) {
        return new ScalecubeServiceDiscovery().transport(cfg -> cfg.transportFactory((TransportFactory)new WebsocketTransportFactory())).options(opts -> opts.metadata((Object)endpoint)).membership(opts -> opts.seedMembers(new Address[]{service.discovery().address()}));
    }
}

