/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.examples.auth;

import io.scalecube.services.auth.MonoAuthUtil;
import io.scalecube.services.examples.auth.CompositeProfile;
import io.scalecube.services.examples.auth.SecuredServiceByCompositeProfile;
import io.scalecube.services.examples.auth.ServiceEndpointProfile;
import io.scalecube.services.examples.auth.UserProfile;
import io.scalecube.services.exceptions.ForbiddenException;
import reactor.core.publisher.Mono;

public class SecuredServiceByCompositeProfileImpl
implements SecuredServiceByCompositeProfile {
    @Override
    public Mono<String> hello(String name) {
        return MonoAuthUtil.deferWithPrincipal(CompositeProfile.class).flatMap(compositeProfile -> {
            UserProfile userProfile = compositeProfile.userProfile();
            ServiceEndpointProfile serviceEndpointProfile = compositeProfile.serviceEndpointProfile();
            this.checkPermissions(userProfile);
            return Mono.just((Object)("Hello, name=" + name + " (userProfile=" + userProfile + ", serviceEndpointProfile=" + serviceEndpointProfile + ")"));
        });
    }

    private void checkPermissions(UserProfile user) {
        if (!user.role().equals("ADMIN")) {
            throw new ForbiddenException("Forbidden");
        }
    }
}

