/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.examples.auth;

import io.scalecube.cluster.transport.api.TransportFactory;
import io.scalecube.net.Address;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceInfo;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.auth.Authenticator;
import io.scalecube.services.auth.CredentialsSupplier;
import io.scalecube.services.auth.MonoAuthUtil;
import io.scalecube.services.discovery.ScalecubeServiceDiscovery;
import io.scalecube.services.examples.auth.CompositeProfile;
import io.scalecube.services.examples.auth.SecuredServiceByCompositeProfileImpl;
import io.scalecube.services.examples.auth.ServiceEndpointProfile;
import io.scalecube.services.examples.auth.UserProfile;
import io.scalecube.services.exceptions.UnauthorizedException;
import io.scalecube.services.impl.Microservices;
import io.scalecube.services.transport.rsocket.RSocketServiceTransport;
import io.scalecube.transport.netty.websocket.WebsocketTransportFactory;
import java.time.Duration;
import java.util.Collections;
import reactor.core.publisher.Mono;

public class CompositeProfileAuthExample {
    public static void main(String[] args) {
        Microservices service = Microservices.builder().discovery(serviceEndpoint -> new ScalecubeServiceDiscovery().transport(cfg -> cfg.transportFactory((TransportFactory)new WebsocketTransportFactory())).options(opts -> opts.metadata((Object)serviceEndpoint))).transport(() -> new RSocketServiceTransport().authenticator(CompositeProfileAuthExample.authenticator())).services(call -> Collections.singletonList(ServiceInfo.fromServiceInstance((Object)new SecuredServiceByCompositeProfileImpl()).authenticator(CompositeProfileAuthExample.compositeAuthenticator()).build())).startAwait();
        Microservices caller = Microservices.builder().discovery(endpoint -> CompositeProfileAuthExample.discovery(service, endpoint)).transport(() -> new RSocketServiceTransport().credentialsSupplier(CompositeProfileAuthExample.credentialsSupplier())).startAwait();
        ServiceMessage response = (ServiceMessage)caller.call().requestOne(ServiceMessage.builder().qualifier("securedServiceByCompositeProfile/hello").header("userProfile.name", "SEGA").header("userProfile.role", "ADMIN").data((Object)"hello world").build(), String.class).block(Duration.ofSeconds(3L));
        System.err.println("### Received 'caller' response: " + response.data());
    }

    private static Authenticator<ServiceEndpointProfile> authenticator() {
        return headers -> {
            String transportSessionKey = (String)headers.get("transportSessionKey");
            if ("asdf7hasd9hasd7fha8ds7fahsdf87".equals(transportSessionKey)) {
                return Mono.just((Object)new ServiceEndpointProfile("endpoint123", "operations"));
            }
            return Mono.error((Throwable)new UnauthorizedException("Authentication failed (transportSessionKey incorrect)"));
        };
    }

    private static CredentialsSupplier credentialsSupplier() {
        return service -> Mono.just(Collections.singletonMap("transportSessionKey", "asdf7hasd9hasd7fha8ds7fahsdf87"));
    }

    private static Authenticator<CompositeProfile> compositeAuthenticator() {
        return headers -> MonoAuthUtil.deferWithPrincipal(ServiceEndpointProfile.class).flatMap(serviceEndpointProfile -> {
            if (!headers.containsKey("userProfile.name") || !headers.containsKey("userProfile.role")) {
                throw new UnauthorizedException("userProfile not found or invalid");
            }
            return Mono.just((Object)new CompositeProfile((ServiceEndpointProfile)serviceEndpointProfile, UserProfile.fromHeaders(headers)));
        });
    }

    private static ScalecubeServiceDiscovery discovery(Microservices service, ServiceEndpoint endpoint) {
        return new ScalecubeServiceDiscovery().transport(cfg -> cfg.transportFactory((TransportFactory)new WebsocketTransportFactory())).options(opts -> opts.metadata((Object)endpoint)).membership(opts -> opts.seedMembers(new Address[]{service.discovery().address()}));
    }
}

