/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.examples;

import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.examples.EmptyGreetingRequest;
import io.scalecube.services.examples.EmptyGreetingResponse;
import io.scalecube.services.examples.GreetingRequest;
import io.scalecube.services.examples.GreetingResponse;
import io.scalecube.services.examples.GreetingService;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.LongStream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class GreetingServiceImpl
implements GreetingService {
    @Override
    public Mono<String> one(String name) {
        return Mono.defer(() -> Mono.just((Object)("Echo:" + name)));
    }

    @Override
    public Flux<Long> manyStream(Long cnt) {
        return Flux.defer(() -> Flux.fromStream(LongStream.range(0L, cnt).boxed()).publishOn(Schedulers.parallel()));
    }

    @Override
    public Mono<String> failingOne(String name) {
        return Mono.defer(() -> Mono.error((Throwable)new RuntimeException(name)));
    }

    @Override
    public Flux<String> many(String name) {
        return Flux.defer(() -> Flux.interval((Duration)Duration.ofMillis(100L)).map(i -> "Greeting (" + i + ") to: " + name));
    }

    @Override
    public Flux<String> failingMany(String name) {
        return Flux.defer(() -> Flux.push(sink -> {
            sink.next((Object)("Echo:" + name));
            sink.next((Object)("Echo:" + name));
            sink.error((Throwable)new RuntimeException("Echo:" + name));
        }));
    }

    @Override
    public Mono<GreetingResponse> pojoOne(GreetingRequest request) {
        return Mono.defer(() -> this.one(request.getText()).map(GreetingResponse::new));
    }

    @Override
    public Mono<List<GreetingResponse>> pojoList(GreetingRequest request) {
        return Mono.defer(() -> this.one(request.getText()).map(GreetingResponse::new).map(Collections::singletonList));
    }

    @Override
    public Flux<GreetingResponse> pojoMany(GreetingRequest request) {
        return Flux.defer(() -> this.many(request.getText()).map(GreetingResponse::new));
    }

    @Override
    public Mono<String> emptyOne(String name) {
        return Mono.empty();
    }

    @Override
    public Flux<String> emptyMany(String name) {
        return Flux.empty();
    }

    @Override
    public Mono<String> neverOne(String name) {
        return Mono.never();
    }

    @Override
    public Mono<String> delayOne(String name) {
        return Mono.defer(() -> Mono.delay((Duration)Duration.ofSeconds(1L)).then(Mono.just((Object)name)));
    }

    @Override
    public Flux<String> delayMany(String name) {
        return Flux.defer(() -> Flux.interval((Duration)Duration.ofMillis(500L), (Duration)Duration.ofSeconds(2L)).map(i -> name));
    }

    @Override
    public Mono<EmptyGreetingResponse> emptyGreeting(EmptyGreetingRequest request) {
        return Mono.just((Object)new EmptyGreetingResponse());
    }

    @Override
    public Mono<ServiceMessage> emptyGreetingMessage(ServiceMessage request) {
        EmptyGreetingRequest greetingRequest = (EmptyGreetingRequest)request.data(EmptyGreetingRequest.class);
        ServiceMessage response = ServiceMessage.from((ServiceMessage)request).data((Object)new EmptyGreetingResponse()).build();
        return Mono.just((Object)response);
    }
}

