/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.examples;

import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.examples.BenchmarkService;
import java.util.concurrent.Callable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BenchmarkServiceImpl
implements BenchmarkService {
    @Override
    public Mono<Void> requestVoid(ServiceMessage request) {
        return Mono.empty();
    }

    @Override
    public Mono<ServiceMessage> one(ServiceMessage message) {
        Callable<ServiceMessage> callable = () -> {
            long value = System.currentTimeMillis();
            return ServiceMessage.from((ServiceMessage)message).header("service-recv-time", (Object)value).header("service-send-time", (Object)value).data((Object)"hello").build();
        };
        return Mono.fromCallable(callable);
    }

    @Override
    public Mono<ServiceMessage> failure(ServiceMessage message) {
        return Mono.defer(() -> Mono.error((Throwable)new RuntimeException("General failure")));
    }

    @Override
    public Flux<ServiceMessage> infiniteStream(ServiceMessage message) {
        ServiceMessage.Builder builder = ServiceMessage.from((ServiceMessage)message);
        return Flux.range((int)0, (int)Integer.MAX_VALUE).map(i -> builder.header("service-send-time", (Object)System.currentTimeMillis()).build());
    }
}

