/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.api;

import io.scalecube.services.transport.api.DataCodec;
import io.scalecube.services.transport.api.HeadersCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JdkCodec
implements DataCodec,
HeadersCodec {
    @Override
    public String contentType() {
        return "application/octet-stream";
    }

    @Override
    public void encode(OutputStream stream, Object value) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectOutputStream oos = new ObjectOutputStream(stream);){
            oos.writeObject(value);
            oos.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void encode(OutputStream stream, Map<String, String> headers) throws IOException {
        if (headers.isEmpty()) {
            return;
        }
        this.writeInt(stream, headers.size());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            byte[] nameBytes = header.getKey().getBytes(StandardCharsets.UTF_8);
            this.writeInt(stream, nameBytes.length);
            stream.write(nameBytes);
            byte[] valueBytes = header.getValue().getBytes(StandardCharsets.UTF_8);
            this.writeInt(stream, valueBytes.length);
            stream.write(valueBytes);
        }
    }

    @Override
    public Object decode(InputStream stream, Type type) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ObjectInputStream is = new ObjectInputStream(stream);){
                return is.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public Map<String, String> decode(InputStream stream) throws IOException {
        if (stream.available() < 1) {
            return Collections.emptyMap();
        }
        int size = this.readInt(stream);
        HashMap<String, String> headers = new HashMap<String, String>(size);
        int i = 0;
        while (i < size) {
            int nameLength = this.readInt(stream);
            byte[] nameBytes = new byte[nameLength];
            stream.read(nameBytes);
            String name = new String(nameBytes, StandardCharsets.UTF_8);
            int valueLength = this.readInt(stream);
            byte[] valueBytes = new byte[valueLength];
            stream.read(valueBytes);
            String value = new String(valueBytes, StandardCharsets.UTF_8);
            headers.put(name, value);
            ++i;
        }
        return headers;
    }

    private void writeInt(OutputStream stream, int number) throws IOException {
        int i = 3;
        while (i >= 0) {
            stream.write(number >>> i * 8);
            --i;
        }
    }

    private Integer readInt(InputStream stream) throws IOException {
        int r = 0;
        int i = 3;
        while (i >= 0) {
            r |= (stream.read() & 0xFF) << i * 8;
            --i;
        }
        return r;
    }
}

