/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface DataCodec {
    public static final Map<String, DataCodec> INSTANCES = ServiceLoader.load(DataCodec.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(DataCodec::contentType, Function.identity()));

    public static Collection<DataCodec> getAllInstances() {
        return INSTANCES.values();
    }

    public static Set<String> getAllContentTypes() {
        return DataCodec.getAllInstances().stream().map(DataCodec::contentType).collect(Collectors.toSet());
    }

    public static DataCodec getInstance(String contentType) {
        Objects.requireNonNull(contentType, "[getInstance] contentType");
        DataCodec dataCodec = INSTANCES.get(contentType);
        Objects.requireNonNull(dataCodec, "[getInstance] dataCodec not found for '" + contentType + "'");
        return dataCodec;
    }

    public String contentType();

    public void encode(OutputStream var1, Object var2) throws IOException;

    public Object decode(InputStream var1, Type var2) throws IOException;
}

