/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.routing;

import io.scalecube.services.routing.Router;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Routers {
    private static final Logger LOGGER = LoggerFactory.getLogger(Routers.class);
    private static final ConcurrentHashMap<Class<? extends Router>, Router> routers = new ConcurrentHashMap();

    private Routers() {
    }

    public static Router getRouter(Class<? extends Router> routerType) {
        return routers.computeIfAbsent(routerType, Routers::create);
    }

    /*
     * WARNING - void declaration
     */
    private static Router create(Class<? extends Router> routerType) {
        try {
            return routerType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            void runtimeException;
            void var3_3;
            RuntimeException runtimeException2;
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            LOGGER.error("Create router type: {} failed: {}", routerType, (Object)t);
            Throwable throwable = t;
            throw throwable instanceof RuntimeException && (runtimeException2 = (RuntimeException)throwable) == (RuntimeException)var3_3 ? runtimeException : new RuntimeException(t);
        }
    }
}

