/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.exceptions;

import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.exceptions.BadRequestException;
import io.scalecube.services.exceptions.ForbiddenException;
import io.scalecube.services.exceptions.InternalServiceException;
import io.scalecube.services.exceptions.ServiceClientErrorMapper;
import io.scalecube.services.exceptions.ServiceException;
import io.scalecube.services.exceptions.ServiceProviderErrorMapper;
import io.scalecube.services.exceptions.ServiceUnavailableException;
import io.scalecube.services.exceptions.UnauthorizedException;
import java.util.Optional;

public final class DefaultErrorMapper
implements ServiceClientErrorMapper,
ServiceProviderErrorMapper {
    public static final DefaultErrorMapper INSTANCE = new DefaultErrorMapper();
    private static final int DEFAULT_ERROR_CODE = 500;

    private DefaultErrorMapper() {
    }

    @Override
    public Throwable toError(ServiceMessage message) {
        ErrorData data = message.data(ErrorData.class);
        int errorType = message.errorType();
        int errorCode = data.errorCode();
        String errorMessage = data.errorMessage();
        switch (errorType) {
            case 400: {
                return new BadRequestException(errorCode, errorMessage);
            }
            case 401: {
                return new UnauthorizedException(errorCode, errorMessage);
            }
            case 403: {
                return new ForbiddenException(errorCode, errorMessage);
            }
            case 503: {
                return new ServiceUnavailableException(errorCode, errorMessage);
            }
            case 500: {
                return new InternalServiceException(errorCode, errorMessage);
            }
        }
        return new InternalServiceException(errorCode, errorMessage);
    }

    @Override
    public ServiceMessage toMessage(String qualifier, Throwable throwable) {
        int errorCode = 500;
        int errorType = 500;
        if (throwable instanceof ServiceException) {
            errorCode = ((ServiceException)throwable).errorCode();
            if (throwable instanceof BadRequestException) {
                errorType = 400;
            } else if (throwable instanceof UnauthorizedException) {
                errorType = 401;
            } else if (throwable instanceof ForbiddenException) {
                errorType = 403;
            } else if (throwable instanceof ServiceUnavailableException) {
                errorType = 503;
            } else if (throwable instanceof InternalServiceException) {
                errorType = 500;
            }
        }
        String errorMessage = Optional.ofNullable(throwable.getMessage()).orElseGet(throwable::toString);
        return ServiceMessage.error(qualifier, errorType, errorCode, errorMessage);
    }
}

