/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.exceptions;

import io.scalecube.services.exceptions.InternalServiceException;
import java.util.regex.Pattern;

public class ConnectionClosedException
extends InternalServiceException {
    private static final Pattern GENERIC_CONNECTION_CLOSED = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);

    public ConnectionClosedException() {
        super("Connection closed");
    }

    public ConnectionClosedException(Throwable cause) {
        super(cause);
    }

    public ConnectionClosedException(String message) {
        super(message);
    }

    public static boolean isConnectionClosed(Throwable th) {
        String message;
        if (th instanceof ConnectionClosedException) {
            return true;
        }
        String string = message = th != null ? th.getMessage() : null;
        return message != null && GENERIC_CONNECTION_CLOSED.matcher(message).matches();
    }
}

