/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.discovery.api;

import io.scalecube.services.ServiceEndpoint;
import java.util.Objects;
import java.util.StringJoiner;

public record ServiceDiscoveryEvent(Type type, ServiceEndpoint serviceEndpoint) {
    public ServiceDiscoveryEvent(Type type, ServiceEndpoint serviceEndpoint) {
        this.type = Objects.requireNonNull(type, "ServiceDiscoveryEvent: type");
        this.serviceEndpoint = Objects.requireNonNull(serviceEndpoint, "ServiceDiscoveryEvent: serviceEndpoint");
    }

    public boolean isEndpointAdded() {
        return Type.ENDPOINT_ADDED == this.type;
    }

    public boolean isEndpointLeaving() {
        return Type.ENDPOINT_LEAVING == this.type;
    }

    public boolean isEndpointRemoved() {
        return Type.ENDPOINT_REMOVED == this.type;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", String.valueOf(ServiceDiscoveryEvent.class.getSimpleName()) + "[", "]").add("type=" + (Object)((Object)this.type)).add("ServiceEndpoint.id='" + this.serviceEndpoint.id() + "'").toString();
    }

    public static ServiceDiscoveryEvent newEndpointAdded(ServiceEndpoint serviceEndpoint) {
        return new ServiceDiscoveryEvent(Type.ENDPOINT_ADDED, serviceEndpoint);
    }

    public static ServiceDiscoveryEvent newEndpointLeaving(ServiceEndpoint serviceEndpoint) {
        return new ServiceDiscoveryEvent(Type.ENDPOINT_LEAVING, serviceEndpoint);
    }

    public static ServiceDiscoveryEvent newEndpointRemoved(ServiceEndpoint serviceEndpoint) {
        return new ServiceDiscoveryEvent(Type.ENDPOINT_REMOVED, serviceEndpoint);
    }

    public static enum Type {
        ENDPOINT_ADDED,
        ENDPOINT_LEAVING,
        ENDPOINT_REMOVED;

    }
}

