/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.discovery.api;

import io.scalecube.net.Address;
import io.scalecube.services.discovery.api.ServiceDiscovery;
import io.scalecube.services.discovery.api.ServiceDiscoveryEvent;
import io.scalecube.services.registry.api.ServiceRegistry;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;

public record ServiceDiscoveryContext(String id, Address address, ServiceDiscovery discovery, ServiceRegistry serviceRegistry, Scheduler scheduler) {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(ServiceDiscoveryContext other) {
        return new Builder().id(other.id).address(other.address).discovery(other.discovery).serviceRegistry(other.serviceRegistry).scheduler(other.scheduler);
    }

    public Flux<ServiceDiscoveryEvent> listen() {
        return Flux.fromStream(this.serviceRegistry.listServiceEndpoints().stream()).map(ServiceDiscoveryEvent::newEndpointAdded).concatWith(this.discovery.listen()).subscribeOn(this.scheduler).publishOn(this.scheduler);
    }

    public static class Builder {
        private String id;
        private Address address;
        private ServiceDiscovery discovery;
        private ServiceRegistry serviceRegistry;
        private Scheduler scheduler;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder discovery(ServiceDiscovery discovery) {
            this.discovery = discovery;
            return this;
        }

        public Builder serviceRegistry(ServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            return this;
        }

        public Builder scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public ServiceDiscoveryContext build() {
            return new ServiceDiscoveryContext(Objects.requireNonNull(this.id, "id"), Objects.requireNonNull(this.address, "address"), Objects.requireNonNull(this.discovery, "discovery"), Objects.requireNonNull(this.serviceRegistry, "serviceRegistry"), Objects.requireNonNull(this.scheduler, "scheduler"));
        }
    }
}

