/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.Reflect;
import io.scalecube.services.ServiceInfo;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceRegistration;
import io.scalecube.services.annotations.ServiceMethod;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ServiceScanner {
    private ServiceScanner() {
    }

    public static List<ServiceRegistration> scanServiceInfo(ServiceInfo serviceInfo) {
        return Reflect.serviceInterfaces(serviceInfo.serviceInstance()).map(serviceInterface -> {
            Map<String, String> serviceInfoTags = serviceInfo.tags();
            Map<String, String> apiTags = Reflect.serviceTags(serviceInterface);
            HashMap<String, String> buffer = new HashMap<String, String>(apiTags);
            buffer.putAll(serviceInfoTags);
            return new InterfaceInfo((Class<?>)serviceInterface, Collections.unmodifiableMap(buffer));
        }).map(interfaceInfo -> {
            Class<?> serviceInterface = interfaceInfo.serviceInterface;
            Map<String, String> serviceTags = interfaceInfo.tags;
            String namespace = Reflect.serviceName(serviceInterface);
            List<ServiceMethodDefinition> actions = Arrays.stream(serviceInterface.getMethods()).filter(method -> method.isAnnotationPresent(ServiceMethod.class)).map(method -> new ServiceMethodDefinition(Reflect.methodName(method), Reflect.serviceMethodTags(method), Reflect.isSecured(method))).collect(Collectors.toList());
            return new ServiceRegistration(namespace, serviceTags, actions);
        }).collect(Collectors.toList());
    }

    private static class InterfaceInfo {
        private final Class<?> serviceInterface;
        private final Map<String, String> tags;

        private InterfaceInfo(Class<?> serviceInterface, Map<String, String> tags) {
            this.serviceInterface = serviceInterface;
            this.tags = tags;
        }
    }
}

