/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.net.Address;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceRegistration;
import io.scalecube.services.api.Qualifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public record ServiceReference(String qualifier, String endpointId, String namespace, Set<String> contentTypes, Map<String, String> tags, String action, Address address, boolean secured) {
    public ServiceReference(String qualifier, String endpointId, String namespace, Set<String> contentTypes, Map<String, String> tags, String action, Address address, boolean secured) {
        this.qualifier = qualifier;
        this.endpointId = endpointId;
        this.namespace = namespace;
        this.contentTypes = Set.copyOf(contentTypes);
        this.tags = Map.copyOf(tags);
        this.action = action;
        this.address = address;
        this.secured = secured;
    }

    public ServiceReference(ServiceMethodDefinition serviceMethodDefinition, ServiceRegistration serviceRegistration, ServiceEndpoint serviceEndpoint) {
        this(Qualifier.asString(serviceRegistration.namespace(), serviceMethodDefinition.action()), serviceEndpoint.id(), serviceRegistration.namespace(), serviceEndpoint.contentTypes(), ServiceReference.mergeTags(serviceMethodDefinition, serviceRegistration, serviceEndpoint), serviceMethodDefinition.action(), serviceEndpoint.address(), serviceMethodDefinition.secured());
    }

    public String oldQualifier() {
        return "/" + this.qualifier();
    }

    private static Map<String, String> mergeTags(ServiceMethodDefinition serviceMethodDefinition, ServiceRegistration serviceRegistration, ServiceEndpoint serviceEndpoint) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.putAll(serviceEndpoint.tags());
        tags.putAll(serviceRegistration.tags());
        tags.putAll(serviceMethodDefinition.tags());
        return tags;
    }
}

