/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.auth.Authenticator;
import io.scalecube.services.auth.PrincipalMapper;
import io.scalecube.services.exceptions.ServiceProviderErrorMapper;
import io.scalecube.services.transport.api.ServiceMessageDataDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public record ServiceInfo(Object serviceInstance, Map<String, String> tags, ServiceProviderErrorMapper errorMapper, ServiceMessageDataDecoder dataDecoder, Authenticator<Object> authenticator, PrincipalMapper<Object, Object> principalMapper) {
    public ServiceInfo(Object serviceInstance, Map<String, String> tags, ServiceProviderErrorMapper errorMapper, ServiceMessageDataDecoder dataDecoder, Authenticator<Object> authenticator, PrincipalMapper<Object, Object> principalMapper) {
        this.serviceInstance = serviceInstance;
        this.tags = Map.copyOf(tags);
        this.errorMapper = errorMapper;
        this.dataDecoder = dataDecoder;
        this.authenticator = authenticator;
        this.principalMapper = principalMapper;
    }

    public static Builder from(ServiceInfo serviceInfo) {
        return new Builder(serviceInfo);
    }

    public static Builder fromServiceInstance(Object serviceInstance) {
        return new Builder(serviceInstance);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", String.valueOf(ServiceInfo.class.getSimpleName()) + "[", "]").add("serviceInstance=" + this.serviceInstance).add("tags(" + this.tags.size() + ")").add("errorMapper=" + this.errorMapper).add("dataDecoder=" + this.dataDecoder).add("authenticator=" + this.authenticator).add("principalMapper=" + this.principalMapper).toString();
    }

    public static class Builder {
        private final Object serviceInstance;
        private final Map<String, String> tags = new HashMap<String, String>();
        private ServiceProviderErrorMapper errorMapper;
        private ServiceMessageDataDecoder dataDecoder;
        private Authenticator<Object> authenticator;
        private PrincipalMapper<Object, Object> principalMapper;

        private Builder(ServiceInfo serviceInfo) {
            this.serviceInstance = serviceInfo.serviceInstance;
            this.tags.putAll(new HashMap<String, String>(serviceInfo.tags));
            this.errorMapper = serviceInfo.errorMapper;
            this.dataDecoder = serviceInfo.dataDecoder;
            this.authenticator = serviceInfo.authenticator;
            this.principalMapper = serviceInfo.principalMapper;
        }

        private Builder(Object serviceInstance) {
            this.serviceInstance = serviceInstance;
        }

        public Builder tag(String key, String value) {
            Objects.requireNonNull(key, "tag key");
            Objects.requireNonNull(value, "tag value");
            this.tags.put(key, value);
            return this;
        }

        public Builder errorMapper(ServiceProviderErrorMapper errorMapper) {
            this.errorMapper = Objects.requireNonNull(errorMapper, "errorMapper");
            return this;
        }

        public Builder dataDecoder(ServiceMessageDataDecoder dataDecoder) {
            this.dataDecoder = Objects.requireNonNull(dataDecoder, "dataDecoder");
            return this;
        }

        public <T> Builder authenticator(Authenticator<? extends T> authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public <T, R> Builder principalMapper(PrincipalMapper<? super T, ? extends R> principalMapper) {
            this.principalMapper = principalMapper;
            return this;
        }

        public Builder errorMapperIfAbsent(ServiceProviderErrorMapper errorMapper) {
            if (this.errorMapper == null) {
                this.errorMapper = errorMapper;
            }
            return this;
        }

        public Builder dataDecoderIfAbsent(ServiceMessageDataDecoder dataDecoder) {
            if (this.dataDecoder == null) {
                this.dataDecoder = dataDecoder;
            }
            return this;
        }

        public Builder authenticatorIfAbsent(Authenticator<Object> authenticator) {
            if (this.authenticator == null) {
                this.authenticator = authenticator;
            }
            return this;
        }

        public Builder principalMapperIfAbsent(PrincipalMapper<Object, Object> principalMapper) {
            if (this.principalMapper == null) {
                this.principalMapper = principalMapper;
            }
            return this;
        }

        public ServiceInfo build() {
            return new ServiceInfo(this.serviceInstance, this.tags, this.errorMapper, this.dataDecoder, this.authenticator, this.principalMapper);
        }
    }
}

