/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.net.Address;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceReference;
import io.scalecube.services.ServiceRegistration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public record ServiceEndpoint(String id, Address address, Set<String> contentTypes, Map<String, String> tags, Collection<ServiceRegistration> serviceRegistrations) implements Serializable
{
    public ServiceEndpoint(String id, Address address, Set<String> contentTypes, Map<String, String> tags, Collection<ServiceRegistration> serviceRegistrations) {
        this.id = id;
        this.address = address;
        this.contentTypes = Set.copyOf(contentTypes);
        this.tags = Map.copyOf(tags);
        this.serviceRegistrations = List.copyOf(serviceRegistrations);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(ServiceEndpoint serviceEndpoint) {
        return new Builder(serviceEndpoint);
    }

    public Collection<ServiceReference> serviceReferences() {
        return this.serviceRegistrations.stream().flatMap(sr -> sr.methods().stream().map(sm -> new ServiceReference((ServiceMethodDefinition)sm, (ServiceRegistration)sr, this))).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", String.valueOf(ServiceEndpoint.class.getSimpleName()) + "[", "]").add("id=" + this.id).add("address=" + this.address).add("contentTypes=" + this.contentTypes).add("tags=" + this.tags).add("serviceRegistrations(" + this.serviceRegistrations.size() + ")").toString();
    }

    public static class Builder {
        private String id;
        private Address address = Address.NULL_ADDRESS;
        private Set<String> contentTypes = Collections.emptySet();
        private Map<String, String> tags = Collections.emptyMap();
        private Collection<ServiceRegistration> serviceRegistrations = new ArrayList<ServiceRegistration>();

        private Builder() {
        }

        private Builder(ServiceEndpoint other) {
            this.id = other.id;
            this.address = other.address;
            this.contentTypes = new HashSet<String>(other.contentTypes);
            this.tags = new HashMap<String, String>(other.tags);
            this.serviceRegistrations = new ArrayList<ServiceRegistration>(other.serviceRegistrations);
        }

        public Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        public Builder address(Address address) {
            this.address = Objects.requireNonNull(address, "address");
            return this;
        }

        public Builder contentTypes(Set<String> contentTypes) {
            this.contentTypes = new HashSet<String>((Collection)Objects.requireNonNull(contentTypes, "contentTypes"));
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = new HashMap<String, String>(Objects.requireNonNull(tags, "tags"));
            return this;
        }

        public Builder appendServiceRegistrations(Collection<ServiceRegistration> serviceRegistrations) {
            this.serviceRegistrations.addAll(Objects.requireNonNull(serviceRegistrations, "serviceRegistrations"));
            return this;
        }

        public Builder serviceRegistrations(Collection<ServiceRegistration> serviceRegistrations) {
            this.serviceRegistrations = new ArrayList<ServiceRegistration>(Objects.requireNonNull(serviceRegistrations, "serviceRegistrations"));
            return this;
        }

        public ServiceEndpoint build() {
            return new ServiceEndpoint(Objects.requireNonNull(this.id, "ServiceEndpoint.id is required"), Objects.requireNonNull(this.address, "ServiceEndpoint.address is required"), this.contentTypes, this.tags, this.serviceRegistrations);
        }
    }
}

