/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.CommunicationMode;
import io.scalecube.services.annotations.RequestType;
import io.scalecube.services.annotations.ResponseType;
import io.scalecube.services.annotations.Service;
import io.scalecube.services.annotations.ServiceMethod;
import io.scalecube.services.annotations.Tag;
import io.scalecube.services.api.Qualifier;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.auth.Secured;
import io.scalecube.services.methods.MethodInfo;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Reflect {
    private Reflect() {
    }

    public static Type parameterizedReturnType(Method method) {
        if (method.isAnnotationPresent(ResponseType.class)) {
            return method.getAnnotation(ResponseType.class).value();
        }
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            Type actualReturnType = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (ServiceMessage.class.equals((Object)actualReturnType)) {
                return Object.class;
            }
            return actualReturnType;
        }
        return Object.class;
    }

    public static boolean isReturnTypeServiceMessage(Method method) {
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            Type actualReturnType = ((ParameterizedType)type).getActualTypeArguments()[0];
            return ServiceMessage.class.equals((Object)actualReturnType);
        }
        return false;
    }

    public static Class<?> requestType(Method method) {
        if (method.getParameterTypes().length > 0) {
            if (method.isAnnotationPresent(RequestType.class)) {
                return method.getAnnotation(RequestType.class).value();
            }
            if (method.getGenericParameterTypes()[0] instanceof ParameterizedType) {
                try {
                    return Class.forName(Reflect.parameterizedRequestType(method).getTypeName());
                }
                catch (ClassNotFoundException e) {
                    return Object.class;
                }
            }
            if (ServiceMessage.class.equals(method.getParameterTypes()[0])) {
                return Object.class;
            }
            return method.getParameterTypes()[0];
        }
        return Void.TYPE;
    }

    public static boolean isRequestTypeServiceMessage(Method method) {
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length < 1) {
            return false;
        }
        if (parameterTypes[0] instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)parameterTypes[0];
            return ServiceMessage.class.equals((Object)parameterizedType.getActualTypeArguments()[0]);
        }
        return ServiceMessage.class.equals((Object)parameterTypes[0]);
    }

    public static Type parameterizedType(Object object) {
        Type type;
        if (object != null && (type = object.getClass().getGenericSuperclass()) instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static Map<Method, MethodInfo> methodsInfo(Class<?> serviceInterface) {
        return Collections.unmodifiableMap(Reflect.serviceMethods(serviceInterface).values().stream().collect(Collectors.toMap(Function.identity(), method -> new MethodInfo(Reflect.serviceName(serviceInterface), Reflect.methodName(method), Reflect.parameterizedReturnType(method), Reflect.isReturnTypeServiceMessage(method), Reflect.communicationMode(method), method.getParameterCount(), Reflect.requestType(method), Reflect.isRequestTypeServiceMessage(method), Reflect.isSecured(method)))));
    }

    public static Type parameterizedRequestType(Method method) {
        Type type;
        if (method != null && method.getGenericParameterTypes().length > 0 && (type = method.getGenericParameterTypes()[0]) instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static String serviceName(Class<?> serviceInterface) {
        Service serviceAnnotation = serviceInterface.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            throw new IllegalArgumentException(String.format("Not a service interface: %s", serviceInterface));
        }
        return serviceAnnotation.value().length() > 0 ? serviceAnnotation.value() : serviceInterface.getName();
    }

    public static Map<String, String> serviceTags(Class<?> serviceInterface) {
        return Reflect.transformArrayToMap((Tag[])serviceInterface.getAnnotationsByType(Tag.class));
    }

    public static Map<String, String> serviceMethodTags(Method serviceMethod) {
        return Reflect.transformArrayToMap((Tag[])serviceMethod.getAnnotationsByType(Tag.class));
    }

    private static Map<String, String> transformArrayToMap(Tag[] array) {
        return array == null || array.length == 0 ? Collections.emptyMap() : Collections.unmodifiableMap(Arrays.stream(array).collect(Collectors.toMap(Tag::key, Tag::value)));
    }

    public static Map<String, Method> serviceMethods(Class<?> serviceInterface) {
        Map methods = Arrays.stream(serviceInterface.getMethods()).filter(method -> method.isAnnotationPresent(ServiceMethod.class)).collect(Collectors.toMap(Reflect::methodName, Function.identity()));
        return Collections.unmodifiableMap(methods);
    }

    public static Stream<Class<?>> serviceInterfaces(Object serviceObject) {
        Class<?> current = serviceObject.getClass();
        HashSet interfaces = new HashSet();
        while (current != Object.class) {
            interfaces.addAll(Arrays.asList(current.getInterfaces()));
            current = current.getSuperclass();
        }
        return interfaces.stream().filter(interfaceClass -> interfaceClass.isAnnotationPresent(Service.class));
    }

    public static String methodName(Method method) {
        ServiceMethod methodAnnotation = method.getAnnotation(ServiceMethod.class);
        return methodAnnotation.value().length() > 0 ? methodAnnotation.value() : method.getName();
    }

    public static String qualifier(Class<?> serviceInterface, Method method) {
        return Qualifier.asString(Reflect.serviceName(serviceInterface), Reflect.methodName(method));
    }

    public static void validateMethodOrThrow(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            return;
        }
        if (!Publisher.class.isAssignableFrom(returnType)) {
            throw new UnsupportedOperationException("Service method return type can be Publisher only");
        }
        Reflect.validateResponseType(method);
        Reflect.validateRequestType(method);
        if (method.getParameterCount() > 1) {
            throw new UnsupportedOperationException("Service method can accept at maximum single parameter");
        }
    }

    private static void validateResponseType(Method method) {
        if (Reflect.isReturnTypeServiceMessage(method)) {
            if (!method.isAnnotationPresent(ResponseType.class)) {
                throw new UnsupportedOperationException("Return type ServiceMessage cannot be used without @ResponseType method annotation");
            }
            if (ServiceMessage.class.equals(method.getAnnotation(ResponseType.class).value())) {
                throw new UnsupportedOperationException("ServiceMessage is not allowed value for @ResponseType");
            }
        }
    }

    private static void validateRequestType(Method method) {
        if (Reflect.isRequestTypeServiceMessage(method)) {
            if (!method.isAnnotationPresent(RequestType.class)) {
                throw new UnsupportedOperationException("Request type ServiceMessage cannot be used without @RequestType method annotation");
            }
            if (ServiceMessage.class.equals(method.getAnnotation(RequestType.class).value())) {
                throw new UnsupportedOperationException("ServiceMessage is not allowed value for @RequestType");
            }
        }
    }

    public static CommunicationMode communicationMode(Method method) {
        Class<Object> returnType = method.getReturnType();
        if (Reflect.isRequestChannel(method)) {
            return CommunicationMode.REQUEST_CHANNEL;
        }
        if (returnType.isAssignableFrom(Flux.class)) {
            return CommunicationMode.REQUEST_STREAM;
        }
        if (returnType.isAssignableFrom(Mono.class)) {
            return CommunicationMode.REQUEST_RESPONSE;
        }
        if (returnType.isAssignableFrom(Void.TYPE)) {
            return CommunicationMode.FIRE_AND_FORGET;
        }
        throw new IllegalArgumentException("Service method is not supported (check return type or parameter type): " + method);
    }

    private static boolean isRequestChannel(Method method) {
        Class<?>[] reqTypes = method.getParameterTypes();
        return reqTypes.length > 0 && (Flux.class.isAssignableFrom(reqTypes[0]) || Publisher.class.isAssignableFrom(reqTypes[0]));
    }

    public static boolean isService(Class<?> type) {
        return type.isAnnotationPresent(Service.class);
    }

    public static boolean isSecured(Method method) {
        return method.isAnnotationPresent(Secured.class) || method.getDeclaringClass().isAnnotationPresent(Secured.class);
    }
}

