package io.scalecube.services.methods;

import java.lang.reflect.Type;
import io.scalecube.services.CommunicationMode;
import io.scalecube.services.api.Qualifier;

public record MethodInfo(
    String serviceName,
    String methodName,
    String qualifier,
    Type parameterizedReturnType,
    boolean returnTypeServiceMessage,
    CommunicationMode communicationMode,
    int parameterCount,
    Class<?> requestType,
    boolean requestTypeServiceMessage,
    boolean secured) {


  /**
   * Create a new service info.
   *
   * @param serviceName the name of the service
   * @param methodName the name of the methof
   * @param parameterizedReturnType the return type (with generics support)
   * @param returnTypeServiceMessage is return service message
   * @param communicationMode the directions of the method
   * @param parameterCount amount of parameters
   * @param requestType the type of the request
   * @param requestTypeServiceMessage is request service message
   * @param secured is method protected by authentication
   */
  public MethodInfo(
      String serviceName,
      String methodName,
      Type parameterizedReturnType,
      boolean returnTypeServiceMessage,
      CommunicationMode communicationMode,
      int parameterCount,
      Class<?> requestType,
      boolean requestTypeServiceMessage,
      boolean secured) {
    this(
        serviceName,
        methodName,
        Qualifier.asString(serviceName, methodName),
        parameterizedReturnType,
        returnTypeServiceMessage,
        communicationMode,
        parameterCount,
        requestType,
        requestTypeServiceMessage,
        secured);
  }

  public String oldQualifier() {
    return Qualifier.DELIMITER + this.qualifier();
  }

  public boolean isRequestTypeVoid() {
    return requestType.isAssignableFrom(Void.TYPE);
  }
}
