package io.scalecube.services;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public record ServiceRegistration(
    String namespace,
    Map<String, String> tags,
    Collection<ServiceMethodDefinition> methods) implements Serializable {

  /**
   * Create a new service registration.
   *
   * @param namespace the namespace to use
   * @param tags tags
   * @param methods a collection of service method definitions
   */
  public ServiceRegistration(
      String namespace,
      Map<String, String> tags,
      Collection<ServiceMethodDefinition> methods) {
    this.namespace = Objects.requireNonNull(namespace, "ServiceRegistration.namespace is required");
    this.tags = Map.copyOf(tags);
    this.methods = List.copyOf(methods);
  }

  @Override
  public String toString() {
    return new StringJoiner(", ", ServiceRegistration.class.getSimpleName() + "[", "]")
        .add("namespace=" + namespace)
        .add("tags=" + tags)
        .add("methods(" + methods.size() + ")")
        .toString();
  }
}
