package io.scalecube.services;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

/**
 * A Service Method Definition is a single method definition of a service inside service
 * registration.
 */
public record ServiceMethodDefinition(String action, Map<String, String> tags, boolean secured)
    implements Serializable {

  /**
   * Create a new Service Method Definition.
   *
   * @param action method name
   */
  public ServiceMethodDefinition(String action) {
    this(action, Map.of(), false);
  }

  /**
   * Create a new Service Method Definition.
   *
   * @param action method name
   * @param tags tags of this method
   * @param secured is method protected by authentication
   */
  public ServiceMethodDefinition(String action, Map<String, String> tags, boolean secured) {
    this.action = Objects.requireNonNull(action, "ServiceMethodDefinition.action is required");
    this.tags = Map.copyOf(tags);
    this.secured = secured;
  }
}
