/*
 * Decompiled with CFR 0.152.
 */
package flare.eventbus;

import com.esotericsoftware.reflectasm.MethodAccess;
import flare.commons.ReflectionUtil;
import flare.eventbus.EventContext;
import flare.eventbus.EventHandler;
import flare.eventbus.EventSubscriber;
import flare.eventbus.Subscribe;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

final class AnnotatedSubscriberUtil {
    private AnnotatedSubscriberUtil() {
    }

    static <T> Stream<EventSubscriber<? extends T>> findAnnotatedSubscribers(Object obj, Class<T> superEventType) {
        return obj.getClass() == Class.class ? AnnotatedSubscriberUtil.findStaticAnnotatedSubscribers((Class)obj, superEventType) : AnnotatedSubscriberUtil.findInstanceAnnotatedSubscribers(obj, superEventType);
    }

    private static <T> Stream<EventSubscriber<? extends T>> findStaticAnnotatedSubscribers(Class<?> clazz, Class<T> superEventType) {
        return Arrays.stream(clazz.getMethods()).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.isAnnotationPresent(Subscribe.class)).map(method -> AnnotatedSubscriberUtil.createSubscriber(null, method, method, superEventType));
    }

    private static <T> Stream<EventSubscriber<? extends T>> findInstanceAnnotatedSubscribers(Object instance, Class<T> superEventType) {
        Set superTypes = ReflectionUtil.traverseSuperTypes(instance.getClass());
        return Arrays.stream(instance.getClass().getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).flatMap(method -> Stream.concat(superTypes.stream(), Stream.of(instance.getClass())).flatMap(clazz -> AnnotatedSubscriberUtil.getDeclaredMethod(clazz, method).stream()).filter(declaredMethod -> declaredMethod.isAnnotationPresent(Subscribe.class)).findFirst().map(declaredMethod -> AnnotatedSubscriberUtil.createSubscriber(instance, method, declaredMethod, superEventType)).stream());
    }

    private static <T> EventSubscriber<? extends T> createSubscriber(@Nullable Object instance, Method method, Method declaredMethod, Class<T> superEventType) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1 && parameterTypes.length != 2) {
            throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation. It has " + parameterTypes.length + " argument(s), but event handler methods require one or two argument.");
        }
        Class<?> eventType = parameterTypes[0];
        if (!superEventType.isAssignableFrom(eventType) && !superEventType.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation, but takes an argument that is not assignable from: " + superEventType);
        }
        if (parameterTypes.length == 2 && parameterTypes[1] != EventContext.class) {
            throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation, but takes a second argument that does not match: " + EventContext.class);
        }
        Subscribe annotation = declaredMethod.getAnnotation(Subscribe.class);
        return AnnotatedSubscriberUtil.createSubscriber(instance, declaredMethod, eventType, annotation);
    }

    private static <T> EventSubscriber<T> createSubscriber(@Nullable Object instance, Method method, Class<T> eventType, Subscribe annotation) {
        return new EventSubscriber<T>(eventType, EventHandler.builder().ignoreCancelled(annotation.ignoreCancelled()).expirationCount(annotation.expirationCount()).build(AnnotatedSubscriberUtil.createMethodInvokingHandler(instance, method, eventType)), annotation.priority());
    }

    private static Optional<Method> getDeclaredMethod(Class<?> clazz, Method method) {
        try {
            return Optional.of(clazz.getDeclaredMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private static <T> BiConsumer<T, EventContext> createMethodInvokingHandler(@Nullable Object instance, Method listenerMethod, Class<T> eventType) {
        Class[] classArray;
        boolean hasContext = listenerMethod.getParameterTypes().length == 2;
        MethodAccess handlerAccess = MethodAccess.get(listenerMethod.getDeclaringClass());
        String string = listenerMethod.getName();
        if (hasContext) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = eventType;
            classArray = classArray2;
            classArray2[1] = EventContext.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = eventType;
        }
        int methodIndex = handlerAccess.getIndex(string, classArray);
        return (event, context) -> {
            Object[] objectArray;
            if (hasContext) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = event;
                objectArray = objectArray2;
                objectArray2[1] = context;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = event;
            }
            handlerAccess.invoke(instance, methodIndex, objectArray);
        };
    }
}

