package flare.eventbus;

/**
 * A subscriber to an event.
 * 
 * @param <T> - event type to subscribe to
 */
public record EventSubscriber<T>(Class<T> eventType, EventHandler<T> handler, int priority)
    implements Comparable<EventSubscriber<T>> {

  public static final int NORMAL_PRIORITY = 0;

  public EventSubscriber(Class<T> eventType, EventHandler<T> handler) {
    this(eventType, handler, NORMAL_PRIORITY);
  }

  @Override
  public int compareTo(EventSubscriber<T> o) {
    return Integer.compare(this.priority, o.priority);
  }
}
