package flare.eventbus;

public sealed interface EventContext permits EmptyEventContext, CancellableEventContext {

  static EventContext empty() {
    return EmptyEventContext.INSTANCE;
  }

  static EventContext cancellable() {
    return new CancellableEventContext();
  }

  default boolean isCancellable() {
    return false;
  }

  default boolean isCancelled() {
    return false;
  }

  default void cancel() {
    this.setCancelled(true);
  }

  default void setCancelled(boolean cancelled) {
    throw new UnsupportedOperationException("Event not cancellable");
  }
}
