package flare.eventbus;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import flare.commons.ReflectionUtil;
import flare.commons.WeakIdentityHashMap;

final class CachedClassHierarchyService implements ClassHierarchyService {

  static final CachedClassHierarchyService INSTANCE = new CachedClassHierarchyService();

  private final AtomicReference<Map<Class<?>, Class<?>[]>> map =
      new AtomicReference<>(new WeakIdentityHashMap<>());

  private CachedClassHierarchyService() {}

  @SuppressWarnings("unchecked")
  @Override
  public <T> Class<? super T>[] superTypesOf(Class<T> clazz) {
    var map = this.map.get();
    var superTypes = (Class<? super T>[]) map.get(clazz);
    return superTypes == null ? this.updateSuperTypes(clazz) : superTypes;
  }

  @SuppressWarnings("unchecked")
  private synchronized <T> Class<? super T>[] updateSuperTypes(Class<T> clazz) {
    var map = this.map.get();
    // Re-retrieve to ensure we have the latest version
    var superTypes = (Class<? super T>[]) map.get(clazz);
    if (superTypes != null) {
      return superTypes;
    }
    superTypes = ReflectionUtil.traverseSuperTypes(clazz).toArray(Class[]::new);
    map.put(clazz, superTypes);
    this.map.lazySet(map);
    return superTypes;
  }
}
