/*
 * Decompiled with CFR 0.152.
 */
package flare.eventbus;

import flare.eventbus.BuiltEventListener;
import flare.eventbus.EventContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

@FunctionalInterface
public interface EventHandler<T> {
    public Result handle(T var1, EventContext var2);

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> EventHandler<T> of(Consumer<T> handler) {
        return EventHandler.withResult(handler, Result.SUCCESS);
    }

    public static <T> EventHandler<T> withResult(Consumer<T> handler, Result result) {
        return (event, context) -> {
            handler.accept(event);
            return result;
        };
    }

    public static <T> EventHandler<T> of(BiConsumer<T, EventContext> handler) {
        return EventHandler.withResult(handler, Result.SUCCESS);
    }

    public static <T> EventHandler<T> withResult(BiConsumer<T, EventContext> handler, Result result) {
        return (event, context) -> {
            handler.accept(event, context);
            return result;
        };
    }

    public static class Builder<T> {
        private final List<Predicate<T>> filters = new ArrayList<Predicate<T>>();
        private boolean ignoreCancelled = true;
        private int expirationCount;
        private Predicate<T> expireWhen;

        protected Builder() {
        }

        public Builder<T> filter(Predicate<T> filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder<T> ignoreCancelled(boolean ignoreCancelled) {
            this.ignoreCancelled = ignoreCancelled;
            return this;
        }

        public Builder<T> expirationCount(int expirationCount) {
            this.expirationCount = expirationCount;
            return this;
        }

        public Builder<T> expireWhen(Predicate<T> expireWhen) {
            this.expireWhen = expireWhen;
            return this;
        }

        public EventHandler<T> build(Consumer<T> handler) {
            return new BuiltEventListener<T>(this.ignoreCancelled, this.expirationCount > 0 ? new AtomicInteger(this.expirationCount) : null, this.expireWhen, this.filters.isEmpty() ? null : (Predicate[])this.filters.toArray(Predicate[]::new), handler);
        }
    }

    public static enum Result {
        SUCCESS,
        INVALID,
        EXPIRED;

    }
}

