/*
 * Decompiled with CFR 0.152.
 */
package flare.eventbus;

import flare.eventbus.ClassHierarchyService;
import flare.eventbus.EventBusImpl;
import flare.eventbus.EventContext;
import flare.eventbus.EventHandler;
import flare.eventbus.EventSubscriber;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface EventBus<T> {
    public static EventBus<Object> create() {
        return EventBus.create(Object.class);
    }

    public static <T> EventBus<T> create(Class<T> eventType) {
        return EventBus.create(eventType, true);
    }

    public static <T> EventBus<T> create(Class<T> eventType, boolean hierarchicalDispatch) {
        return EventBus.create(eventType, hierarchicalDispatch ? ClassHierarchyService.cached() : null);
    }

    public static <T> EventBus<T> create(Class<T> eventType, @Nullable ClassHierarchyService hierarchyService) {
        return new EventBusImpl<T>(eventType, hierarchyService);
    }

    default public <E extends T> void publish(E event) {
        this.publish(event, EventContext.empty());
    }

    default public <E extends T> boolean publishCancellable(E event) {
        return this.publish(event, EventContext.cancellable()).isCancelled();
    }

    public <E extends T> EventContext publish(E var1, EventContext var2);

    public Class<T> eventType();

    public Optional<EventBus<? super T>> parent();

    public Set<EventBus<? extends T>> children();

    public <E extends T> EventBus<T> addChild(EventBus<E> var1);

    public <E extends T> EventBus<T> removeChild(EventBus<E> var1);

    public EventBus<T> subscribeAnnotated(Object var1);

    public EventBus<T> unsubscribeAnnotated(Object var1);

    default public <E extends T> EventBus<T> subscribe(Class<E> eventType, Consumer<E> handler) {
        return this.subscribe(eventType, EventHandler.of(handler));
    }

    default public <E extends T> EventBus<T> subscribe(Class<E> eventType, BiConsumer<E, EventContext> handler) {
        return this.subscribe(eventType, EventHandler.of(handler));
    }

    default public <E extends T> EventBus<T> subscribe(Class<E> eventType, EventHandler<E> handler) {
        return this.subscribe(new EventSubscriber<E>(eventType, handler));
    }

    public <E extends T> EventBus<T> subscribe(EventSubscriber<E> var1);

    public <E extends T> EventBus<T> unsubscribe(EventSubscriber<E> var1);
}

